from sandbox import sdk2
from sandbox.projects.common import binary_task


class UpdateDynTrashfilter(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        disk_space = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 5 * 60 * 60
        yt_token = sdk2.parameters.YavSecret(
            "YAV secret identifier with YT OAuth token",
            default="sec-01ft5frsqx6dpn33x9v4njaq6y"
        )
        yt_pool = sdk2.parameters.String("YT pool")

        stat_days = sdk2.parameters.Integer('How old dyn_bs_log tables to process', default=365, description='This parameter affects speed of execution, if you want just to test, try to use value 10')
        ban_window_days = sdk2.parameters.Integer('Ban window days', default=60, description='This parameter affects speed of execution, if you want just to test, try to use value 5')

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        import bannerland.resource_generation.update_dyn_trashfilter.lib as update_dyn_trashfilter

        update_dyn_trashfilter.run(
            self,
            yt_client=update_dyn_trashfilter.get_yt_client(
                self.Parameters.yt_token.data()['yt_token'],
                self.Parameters.yt_pool,
                'hahn',
            ),
            release_type=self.Parameters.ext_params.binary_executor_release_type,
            stat_days=self.Parameters.stat_days,
            ban_window_days=self.Parameters.ban_window_days,
        )
