# coding: utf-8

import logging
import argparse
import datetime

import bannerland.dir_worker.dir_worker
import bannerland.archive_workers.common

logging.basicConfig(format="%(asctime)s\t[%(process)d]\t%(message)s", level=logging.INFO)


def main_run(worker_name, dir):
    logging.info('set %s as done for dir %s ...', worker_name, dir)

    attr_name = bannerland.archive_workers.common.get_attr_name(worker_name)

    worker = bannerland.dir_worker.dir_worker.YtDirWorker(attr_name)
    worker.set_dir_worker_attr_done(dir, datetime.datetime.now())

    logging.info('done!')

if __name__ == '__main__':
    argparser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    argparser.add_argument('worker_name')
    argparser.add_argument('dir')
    args = argparser.parse_args()
    main_run(args.worker_name, args.dir)
