import argparse

import yt.wrapper as yt

import irt.bannerland.full_state.converter.v4 as fs_converter


if __name__ == '__main__':
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--task-type', choices=['perf', 'dyn'])
    parser.add_argument('--cmp-type', choices=['default', 'grut'])
    parser.add_argument('--yt-cluster', choices=['hahn', 'arnold'], default='hahn')
    parser.add_argument('--yt-pool', default='bannerland-data')
    parser.add_argument('--input', help='bannerphrases table path', required=True)
    parser.add_argument('--output', help='output banner v4 table path', required=True)
    args = parser.parse_args()

    yt_config = {}
    if args.yt_pool:
        yt_config['spec_defaults'] = {}
        yt_config['spec_defaults']['pool'] = args.yt_pool

    yt_client = yt.YtClient(proxy=args.yt_cluster, config=yt_config)
    fs_converter.convert_to_v4(args.task_type, yt_client, args.input, args.output, args.cmp_type)
