# -*- coding: utf8 -*-

import socket
import argparse
import random

import yt.wrapper as yt

import bannerland.yql.tools
import bannerland.yt_local
from irt.bannerland.hosts import get_curr_host


def get_remote_yt_client():
    return yt.YtClient(proxy='hahn')


def get_local_yt_client():
    proxy = bannerland.yt_local.get_proxy()
    return yt.YtClient(proxy=proxy)


def get_yql_client():
    return bannerland.yql.tools.get_client(db='hahn')


if __name__ == "__main__":
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    subparsers = parser.add_subparsers(title='commands', metavar='', dest='cmd')

    download_parser = subparsers.add_parser('download', help='download local yt archive from sandbox and unpack it')
    download_parser.add_argument('--stable', action='store_true')

    subparsers.add_parser('start', help='start local yt instance')
    subparsers.add_parser('stop', help='stop local yt instance')
    subparsers.add_parser('delete', help='delete local yt instance')

    parser_ytproxy = subparsers.add_parser('list', help='print proxy of running local yt instance')
    parser_ytproxy.add_argument('--verbose', '-v', action='store_true', help='print useful commands')

    args = parser.parse_args()
    cmd = args.cmd

    if cmd == 'download':
        bannerland.yt_local.download(stable=args.stable)
    elif cmd == 'start':
        bannerland.yt_local.start()
    elif cmd == 'stop':
        bannerland.yt_local.stop()
    elif cmd == 'delete':
        bannerland.yt_local.delete()
    elif cmd == 'list':
        yt_proxy = bannerland.yt_local.get_proxy()
        if args.verbose:
            yt_port = int(yt_proxy.split(':')[1])
            yt_server = socket.gethostname()
            local_port = yt_port + random.randint(1000, 2000)
            docker_image = 'registry.yandex.net/yt/thor:stable'
            cur_host = get_curr_host()
            if cur_host == 'catalogia-media-dev02e.yandex.ru':
                cur_host = 'catalogia-media-dev02e.yandex.net'  # это CNAME, для морды yt требуется адрес *yandex.net

            print('You can try use web-interface at ')
            print('https://yt.yandex-team.ru/{}:{}'.format(cur_host, yt_port))
            print('In case of network errors try different browser. Browsers other than Ya.Browser are unreliable')
            print ('')
            print('YT proxy: {}'.format(yt_proxy))
            print('To use local yt web-interface, run these commands on your computer:')
            print('(use sudo if required)')
            print('')
            print(' ssh -fN -L {}:localhost:{} {}'.format(local_port, yt_port, yt_server))
            print(' docker run -itd -p {}:80 -e PROXY=localhost:{} -e ENV_OVERRIDE=local --rm {}'.format(
                yt_port, local_port, docker_image,
            ))
            print('')
            print('visit local yt web-interface at http://localhost:{}'.format(yt_port))
        else:
            print(yt_proxy)
