import jinja2
import json
import os
import shutil
import subprocess
import sys

import library.python.resource


jinja2_env = jinja2.Environment()
options_template = jinja2_env.from_string(library.python.resource.find('options.py.j2').decode())


def is_osx() -> bool:
    return sys.platform == "darwin"


def path_env(common_options_path: str) -> str:
    if is_osx():
        return os.getenv('PATH')
    return f'{common_options_path}:/bin'


def extra_perl_libs(common_options_path: str) -> list[str]:
    if is_osx():
        return []
    return [
        f'{common_options_path}/etc/perl',
        f'{common_options_path}/usr/local/lib/perl/5.14.2',
        f'{common_options_path}/usr/lib/perl5',
        f'{common_options_path}/usr/share/perl5',
        f'{common_options_path}/usr/lib/perl/5.14',
        f'{common_options_path}/usr/share/perl/5.14',
    ]


def main():
    build_arc_root = os.path.abspath(os.path.join(os.getcwd(), '../../'))
    common_options_path = os.path.join(os.getcwd(), 'common_options')
    if not is_osx():
        subprocess.check_output(
            ['tar', '-xf', 'perl.tgz'],
            cwd=common_options_path,
        )
    perl5lib = extra_perl_libs(common_options_path)
    shutil.copy(
        os.path.join(os.getenv('ARCADIA_ROOT'), 'rt-research/broadmatching/scripts/common-options'),
        os.path.join(os.getcwd(), 'scripts/common-options'),
    )
    shutil.copytree(
        os.path.join(os.getenv('ARCADIA_ROOT'), 'rt-research/broadmatching/scripts/lib'),
        os.path.join(os.getcwd(), 'scripts/lib'),
        dirs_exist_ok=True,
        symlinks=True,
        ignore_dangling_symlinks=True,
    )
    with open(os.path.join(common_options_path, 'options.py'), 'w') as options:
        options_json = json.loads(subprocess.check_output(
            ['perl', 'common-options', '--all'],
            cwd=os.path.join(os.getcwd(), 'scripts'),
            env={
                'LD_LIBRARY_PATH': f'{common_options_path}/usr/lib',
                'PERL5LIB': ':'.join(perl5lib),
                'PATH': path_env(common_options_path),
            },
        ).decode())
        options_str = str(options_json)
        options_str = options_str.replace('\'' + build_arc_root, 'env_arcadia_root + \'')
        options_str = options_str.replace(' ' + build_arc_root, ' \' + env_arcadia_root + \'')
        options.write(options_template.render(options=options_str))


if __name__ == '__main__':
    main()
