#! /bin/bash
set -x -e
set -o pipefail

rm -rf perllibs.tgz

sudo apt-get install \
    libcache-memcached-fast-perl=0.19-2build1 \
    libcarp-clan-perl=6.04-1 \
    libclass-accessor-perl=0.34-1 \
    libcoro-perl=6.370-yandex6 \
    libdate-calc-perl=6.3-1 \
    libdate-calc-xs-perl=6.2-1build1 \
    libdbi-perl=1.616-1build2 \
    libencode-detect-perl=1.01-2build2 \
    libfftw3-3=3.3-1ubuntu1 \
    libguard-perl=1.022-1build1 \
    libio-compress-perl=2.048-1 \
    libjson-perl=2.53-1 \
    liblcms1=1.19.dfsg-1ubuntu3 \
    liblqr-1-0=0.4.1-1.1 \
    libltdl7=2.4.2-1ubuntu1 \
    libmagickcore5=8:6.8.8.10-yandex6 \
    libnet-dns-perl=0.66-2ubuntu3 \
    libnet-inet6glue-perl=0.5-1 \
    libnet-server-perl=0.99-3 \
    libsub-name-perl=0.05-1build2 \
    libxml-parser-perl=2.41-1build1 \
    libyaml-syck-perl=1.19-1 \
    libyandex-dssm-perl=1.0.2446672 \
    libyxqueryrec-perl=1.1443~arc857092-1 \
    pdl=1:2.4.7+dfsg-2ubuntu5 \
    perlmagick=8:6.8.8.10-yandex6 \
    yabs-libsoap-lite-perl=000.3 \
    yandex-matrixnet-perl=1849748.trunk \
    libdbd-sqlite3-perl=1.35-1 \
    libhtml-parser-perl=3.69-1build1 \
    libhtml-tagset-perl=3.20-2 \
    libhtml-tree-perl=4.2-1 \
    libjson-xs-perl=2.320-1build1 \
    libcommon-sense-perl=3.4-1 \
    ;

./collect_perllibs.pl

BLUE='\033[1;34m'
NC='\033[0m'
echo -e "${BLUE}Now call
  ya upload perl.tgz --ttl inf --owner BROADMATCH -T BROADMATCH_MR_CATALOGIA_EXTERNAL  -d 'perllibs.tgz on `date`' -A type=perllibs
and reupload external_pack (https://sandbox.yandex-team.ru/resources?type=BROADMATCH_MR_CATALOGIA_EXTERNAL&page=1&pageCapacity=20&attrs=%7B%7D&state=READY&attr_name=type&attr_value=external_pack)
${NC}"
