#! /usr/bin/env perl

use strict;
use warnings;

sub xsystem {
    system(@_) and die "Could not run:\n@_\n$@ $!";
}

xsystem("mkdir 4perllibs");

# AUTO
my $auto_dst_dir = "4perllibs/auto";
my $auto_src_dirs = ["/usr/lib/perl5/auto", "/usr/lib/perl/5.14.2/auto"];
for my $auto (qw{
    Cache/Memcached/Fast/Fast.so
    Cache/Memcached/Fast/Fast.so
    Compress/Raw/Bzip2/autosplit.ix
    Compress/Raw/Bzip2/Bzip2.so
    Compress/Raw/Zlib/autosplit.ix
    Compress/Raw/Zlib/Zlib.so
    Coro/State/State.so
    Cwd/Cwd.so
    Date/Calc/XS/XS.so
    DBI/DBI.so
    DSSM/libDSSM.so
    Encode/Detect/Detector/Detector.so
    Guard/Guard.so
    Image/Magick/Q16/Q16.so
    Matrixnet/libMatrixnet.so
    Net/DNS/DNS.so
    Socket/Socket.so
    Sub/Name/Name.so
    XML/Parser/Expat/Expat.so
    YAML/Syck/Syck.so
    DBD/SQLite/SQLite.so
    DBD/SQLite/SQLite.bs
    HTML/Parser/Parser.so
    HTML/Parser/Parser.bs
    JSON/XS/XS.bs
    JSON/XS/XS.so
}) {
    $auto =~ m{^(.+)/.+$};
    xsystem("mkdir -p $auto_dst_dir/$1");
    my $cmd = join " || ", map { "cp -L $_/$auto $auto_dst_dir/$auto" } @$auto_src_dirs;
    xsystem($cmd);
}

# PM
my $pm_dst_dir = "4perllibs";
my $pm_src_dirs = ["/usr/share/perl5", "/usr/lib/perl5", "/usr/lib/perl/5.14.2", "/usr/share/perl/5.14.2"];
for my $pm (qw{
    Cache/Memcached/Fast.pm
    Carp/Clan.pm
    Class/Accessor/Fast.pm
    Class/Accessor.pm
    Compress/Raw/Bzip2.pm
    Compress/Raw/Zlib.pm
    Compress/Zlib.pm
    Coro/jit-amd64-unix.pl
    Coro.pm
    Coro/State.pm
    Cwd.pm
    Date/Calc.pm
    Date/Calc/XS.pm
    DBI.pm
    DSSM.pm
    Encode/Detect/Detector.pm
    File/GlobMapper.pm
    File/Slurp.pm
    File/Spec.pm
    File/Spec/Unix.pm
    Getopt/Long.pm
    Guard.pm
    Image/Magick.pm
    Image/Magick/Q16.pm
    IO/Compress/Adapter/Deflate.pm
    IO/Compress/Base/Common.pm
    IO/Compress/Base.pm
    IO/Compress/Gzip/Constants.pm
    IO/Compress/Gzip.pm
    IO/Compress/RawDeflate.pm
    IO/Compress/Zip/Constants.pm
    IO/Compress/Zlib/Constants.pm
    IO/Compress/Zlib/Extra.pm
    IO/Uncompress/Adapter/Bunzip2.pm
    IO/Uncompress/Adapter/Identity.pm
    IO/Uncompress/Adapter/Inflate.pm
    IO/Uncompress/AnyUncompress.pm
    IO/Uncompress/Base.pm
    IO/Uncompress/Bunzip2.pm
    IO/Uncompress/Gunzip.pm
    IO/Uncompress/Inflate.pm
    IO/Uncompress/RawInflate.pm
    IO/Uncompress/Unzip.pm
    JSON.pm
    Matrixnet.pm
    Net/DNS/Header.pm
    Net/DNS/Packet.pm
    Net/DNS.pm
    Net/DNS/Question.pm
    Net/DNS/Resolver/Base.pm
    Net/DNS/Resolver.pm
    Net/DNS/Resolver/UNIX.pm
    Net/DNS/RR.pm
    Net/DNS/RR/Unknown.pm
    Net/DNS/Update.pm
    Net/INET6Glue/FTP.pm
    Net/INET6Glue/INET_is_INET6.pm
    Net/INET6Glue.pm
    Net/Server/Daemonize.pm
    Net/Server/HTTP.pm
    Net/Server/MultiType.pm
    Net/Server.pm
    Net/Server/Proto.pm
    Parallel/ForkManager.pm
    SOAP/Lite.pm
    Socket.pm
    Sub/Name.pm
    XML/Parser/Expat.pm
    XML/Parser.pm
    YAML/Syck.pm
    YxQueryrec.pm
    YxQueryrec/queryrec.dict
    YxQueryrec/queryrec.weights
    DBD/SQLite.pm
    HTML/PullParser.pm
    HTML/Parser.pm
    HTML/Entities.pm
    HTML/LinkExtor.pm
    HTML/TokeParser.pm
    HTML/Filter.pm
    HTML/HeadParser.pm
    HTML/Parse.pm
    HTML/AsSubs.pm
    HTML/Tree.pm
    HTML/Tree/AboutObjects.pod
    HTML/Tree/AboutTrees.pod
    HTML/Tree/Scanning.pod
    HTML/Element/traverse.pm
    HTML/Element.pm
    HTML/TreeBuilder.pm
    HTML/Tagset.pm
    JSON/XS/Boolean.pm
    JSON/XS.pm
    common/sense.pm
}) {
    $pm =~ m{^(.+)/.+$};
    xsystem("mkdir -p $pm_dst_dir/$1");
    my $cmd = join " || ", map { "cp -L $_/$pm $pm_dst_dir/$pm" } @$pm_src_dirs;
    xsystem($cmd);
}

# SO
for my $so (qw{
    /usr/lib/libfftw3.so.3
    /usr/lib/x86_64-linux-gnu/liblcms.so.1
    /usr/lib/x86_64-linux-gnu/libltdl.so.7
    /usr/lib/liblqr-1.so.0
    /usr/lib/libMagickCore-6.Q16.so.2
    /usr/share/perl5/libYxQueryrec.so
}) {
    xsystem("cp -L $so $pm_dst_dir/");
}

xsystem("cd 4perllibs && echo 'lib' > _mr_target_dir && tar -czf ../perllibs.tgz _mr_target_dir *");
xsystem("rm -rf 4perllibs");
