from ads.libs.python.resourceargparse import ArgumentParser
from lib_cycles import need_run, run_yql
from bm_mr.resources import home


HAHN_DEFAULT = 'hahn'


def main():
    argparser = ArgumentParser(resource_arg_is_required=False, args_for_setting_resource=['-c', '--config'])
    argparser.add_argument('--source', type=str, default=home.bs.ads.broadmatch.sd17dyn.recs.read())
    argparser.add_argument('--target', type=str, default=home.broadmatching.bmyt.publish.input.insight_dynamic_speedup.write())
    argparser.add_argument('--sim-distance', type=int, required=True)
    argparser.add_argument('--context-type', type=int, required=True)
    argparser.add_argument('--cluster', type=str, default=HAHN_DEFAULT)
    argparser.add_argument('--force', action='store_true')
    args = argparser.parse_args()

    if args.force or need_run(source=args.source, target=args.target, cluster=args.cluster):
        run_yql(
            source=args.source, target=args.target, cluster=args.cluster,
            context_type=args.context_type, sim_distance=args.sim_distance
        )


if __name__ == '__main__':
    main()
