#!/usr/bin/python
# -*- coding: utf-8 -*-
import datetime
import logging

import ads.libs.yql
import yt.wrapper as yt
from bm_mr.resources import home

logger = logging.getLogger(__name__)

HAHN_DEFAULT = 'hahn'
POOL_BROADMATCHING = 'broadmatching'


def get_stat_day_banners(**args):
    query = '''
      INSERT INTO `{output_table}` WITH TRUNCATE
      SELECT BannerID
      FROM `{logs_dir}/{date}`
      WHERE
        fraudbits == "0" and placeid == "542"
      GROUP BY
        CAST(bannerid AS Uint64) as BannerID
    ;
    '''.format(**args)
    logger.info('run query: ' + query)
    ads.libs.yql.run_yql_query(query=query, db=HAHN_DEFAULT, pool=POOL_BROADMATCHING)


def get_stat_banners(**args):
    query = '''
      INSERT INTO `{output_table}` WITH TRUNCATE
      SELECT b.bid AS bid
      FROM `{banners_table}` AS b
      INNER JOIN
        (SELECT DISTINCT
          BannerID
          FROM
          RANGE(`{stat_dir}`, `{start_date}`, `{stop_date}`)
        ) AS S ON S.BannerID = b.BannerID
      ;
    '''.format(**args)
    logger.info('run query: ' + query)
    ads.libs.yql.run_yql_query(query=query, db=HAHN_DEFAULT, pool=POOL_BROADMATCHING)


def cleanup(dir_path, n_tables):
    tables = sorted(map(str, yt.list(dir_path)), reverse=True)
    while len(tables) > n_tables:
        tbl = tables.pop()
        logger.info('cleanup: ' + dir_path + "/" + tbl)
        yt.remove(dir_path + "/" + tbl)


def main():
    # noinspection PyUnresolvedReferences
    yt.config["proxy"]["url"] = HAHN_DEFAULT
    n_days = 14

    logs_dir = home.logfeller.logs.bs_chevent_log.n1d.read()
    stat_dir = home.broadmatching.work.queue.stat.write()

    changed = False
    stat_tables = map(str, yt.list(stat_dir))
    if stat_tables:
        curr_date = datetime.datetime.strptime(max(stat_tables), '%Y-%m-%d').date()
        curr_date += datetime.timedelta(1)
    else:
        curr_date = datetime.date.today() - datetime.timedelta(n_days)

    while yt.exists(logs_dir + '/' + str(curr_date)):
        get_stat_day_banners(
            logs_dir=logs_dir,
            output_table=stat_dir + '/' + str(curr_date),
            date=curr_date,
        )
        changed = True
        curr_date += datetime.timedelta(1)

    if changed:
        get_stat_banners(
            banners_table=home.direct.export.bm.bm_banners.read(),
            output_table=home.broadmatching.work.queue.bids_shows_14days.write(),
            stat_dir=stat_dir,
            start_date=curr_date - datetime.timedelta(n_days - 1),
            stop_date=curr_date,
        )
    else:
        logger.info("Nothing to do")
    cleanup(dir_path=stat_dir, n_tables=n_days + 2)


if __name__ == '__main__':
    main()
