import ads.libs.yql
from textwrap import dedent
from bm_mr.resources import home


HAHN_DEFAULT = 'hahn'
POOL_BROADMATCHING = 'broadmatching'


def main():
    query = dedent('''
        pragma File('bigb.so', 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={{"released":"stable"}}');
        pragma udf('bigb.so');

        pragma yt.DefaultMaxJobFails = "1";
        $p = DateTime2::Parse('%Y-%m-%d %H:%M:%S');
        $ts = ($t) -> {{
            -- yql v0: DateTime::ToSeconds(DateTime::FromStringFormat($t, '%Y-%m-%d %H:%M:%S') - DateTime::FromHours(3))
            RETURN CAST(DateTime2::ToSeconds(DateTime2::MakeDatetime($p($t))) - 3 * 3600 AS Uint64);
        }};
        insert into `{banners_creation_time_slow}` with truncate
        select cid, pid, bid, max(BannerID) as BannerID, min(`timestamp`) as `timestamp` from (
            select cid, pid, bid, BannerID, $ts(LastChange) as `timestamp`
            from `{direct_db_banners}`
            union all
            select cid, pid, bid, BannerID, $ts(LastChange) as `timestamp`
            from `{direct_dbarnold_banners}`
            union all
            select cid, pid, bid, BannerID, `timestamp` from
            `{banners_creation_time_slow}`
        )
        group by cid, pid, bid;

        COMMIT;

        $banners = SELECT
            BannerID,
            Bigb::ParseBannerProfileProto(BannerProfileNoTsar) as banner
        FROM
            `//home/bs/logs/AdsCaesarBannersDump/latest`;

        $caesarBanners = SELECT
            BannerID,
            banner.OrderID as OrderID,
            banner.Resources.DirectBannersLogFields.DirectBannerID as bid,
            banner.Resources.GroupBannerID as pid,
            banner.Flags.FirstSeenInCaesarTimestamp as `timestamp`
        FROM
            $banners
        WHERE
            banner.Resources.DirectBannersLogFields.DirectBannerID IS NOT NULL
        AND
            banner.Flags.Source = 1
        AND
            banner.Flags.FirstSeenInCaesarTimestamp > 0;

        $orders = SELECT
            OrderID,
            Bigb::ParseOrderProfileProto(OrderProfile) as order
        FROM
            `//home/bs/logs/AdsCaesarOrdersDump/latest`;

        $orderToCampaignId = SELECT
            OrderID,
            order.Resources.DirectBannersLogFields.DirectOrderID as cid
        FROM
            $orders;

        $fake_bnrs = SELECT
            caesarBanners.BannerID as BannerID,
            caesarBanners.bid as bid,
            caesarBanners.pid as pid,
            orderToCampaignId.cid as cid,
            caesarBanners.`timestamp` as `timestamp`
        FROM
            $caesarBanners as caesarBanners
        JOIN
            $orderToCampaignId as orderToCampaignId
        ON
            caesarBanners.OrderID = orderToCampaignId.OrderID;

        insert into `{banners_creation_time_fast}` with truncate
        select cid, pid, bid, max(BannerID) as BannerID, min(`timestamp`) as `timestamp` from (
            select *
            from $fake_bnrs
            union all
            select *
            from `{banners_creation_time_slow}`
        )
        group by cid, pid, bid;'''.format(
        banners_creation_time_slow=home.broadmatching.bmyt.direct_export.banners_creation_time_slow.write(),
        direct_db_banners=home.direct.db.banners.read(),
        direct_dbarnold_banners=home.broadmatching.bmyt.direct_export.arnold.banners.read(),
        banners_creation_time_fast=home.broadmatching.bmyt.direct_export.banners_creation_time_fast.write(),
    ))
    ads.libs.yql.run_yql_query(query=query, db=HAHN_DEFAULT, pool=POOL_BROADMATCHING)


if __name__ == '__main__':
    main()
