from datetime import datetime, date, timedelta
import dateutil.parser

from yabs.graphite import GraphiteSender


def parse_date(date_str):
    """
    Convert date to unix time (for graphite)
    :param date_str: string with date
    :return: unix time
    """
    return dateutil.parser.parse(date_str)


def get_date(days_back=1, date_format='%Y-%m-%d'):
    dt = date.today() - timedelta(days_back)
    return dt.strftime(date_format)


def validate_date(date_str, date_format='%Y-%m-%d'):
    try:
        datetime.strptime(date_str, date_format)
    except ValueError:
        return False
    else:
        return True


def write_monitoring_to_graphite(monitoring_name, monitoring_value, datetime_string,
                                 graphite_frequency='one_day', graphite_namespace='bs.bm.monitoring'):
    """
    :param monitoring_name:
    :param monitoring_value:
    :param datetime_string:
    :param graphite_frequency:
    :param graphite_namespace:
    :return:
    """
    monitoring_name = ''.join(monitoring_name.split())
    graphite_sender = GraphiteSender(connect_timeout=10)
    graphite_name = "{}.{}.{}".format(graphite_frequency, graphite_namespace, monitoring_name)
    graphite_sender.send(graphite_name, monitoring_value, parse_date(datetime_string))
    graphite_sender.close()
