-- MySQL dump 10.13  Distrib 5.5.21, for Linux (x86_64)
--
-- Host: localhost    Database: mysql
-- ------------------------------------------------------
-- Server version	5.5.21-55

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

CREATE DATABASE IF NOT EXISTS `mysql` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `mysql`;

--
-- Table structure for table `columns_priv`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `columns_priv` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(16) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Table_name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Column_name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `db` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(16) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT IGNORE INTO `db` VALUES ('localhost','adaptivedb','bmclient','Y','Y','Y','Y','Y','Y','N','N','N','Y','Y','N','N','N','N','N','N','N','N'),('127.0.0.1','adaptivedb','bmclient','Y','Y','Y','Y','Y','Y','N','N','N','Y','Y','N','N','N','N','N','N','N','N'),('141.8.173.40','adaptivedb','bmclient','Y','Y','Y','Y','Y','Y','N','N','N','Y','Y','N','N','N','N','N','N','N','N'),('bmadaptive02e.yandex.ru','adaptivedb','bmclient','Y','Y','Y','Y','Y','Y','N','N','N','Y','Y','N','N','N','N','N','N','N','N'),('bmfront01f.yandex.ru','adaptivedb','bmclient','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(77) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','NOT_USED','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob,
  PRIMARY KEY (`db`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `func` (
  `name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT '0',
  `dl` char(128) COLLATE utf8_bin NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` char(128) NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT IGNORE INTO `help_category` VALUES (1,'Geographic',0,''),(2,'Polygon properties',33,''),(3,'WKT',33,''),(4,'Numeric Functions',37,''),(5,'Plugins',34,''),(6,'MBR',33,''),(7,'Control flow functions',37,''),(8,'Transactions',34,''),(9,'Help Metadata',34,''),(10,'Account Management',34,''),(11,'Point properties',33,''),(12,'Encryption Functions',37,''),(13,'LineString properties',33,''),(14,'Logical operators',37,''),(15,'Miscellaneous Functions',37,''),(16,'Functions and Modifiers for Use with GROUP BY',34,''),(17,'Information Functions',37,''),(18,'Comparison operators',37,''),(19,'Bit Functions',37,''),(20,'Table Maintenance',34,''),(21,'User-Defined Functions',34,''),(22,'Data Types',34,''),(23,'Compound Statements',34,''),(24,'Geometry constructors',33,''),(25,'GeometryCollection properties',1,''),(26,'Administration',34,''),(27,'Data Manipulation',34,''),(28,'Utility',34,''),(29,'Language Structure',34,''),(30,'Geometry relations',33,''),(31,'Date and Time Functions',37,''),(32,'WKB',33,''),(33,'Geographic Features',34,''),(34,'Contents',0,''),(35,'Geometry properties',33,''),(36,'String Functions',37,''),(37,'Functions',34,''),(38,'Data Definition',34,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT IGNORE INTO `help_keyword` VALUES (0,'JOIN'),(1,'HOST'),(2,'REPEAT'),(3,'SERIALIZABLE'),(4,'REPLACE'),(5,'AT'),(6,'SCHEDULE'),(7,'RETURNS'),(8,'STARTS'),(9,'MASTER_SSL_CA'),(10,'NCHAR'),(11,'COLUMNS'),(12,'COMPLETION'),(13,'WORK'),(14,'DATETIME'),(15,'MODE'),(16,'OPEN'),(17,'INTEGER'),(18,'ESCAPE'),(19,'VALUE'),(20,'MASTER_SSL_VERIFY_SERVER_CERT'),(21,'SQL_BIG_RESULT'),(22,'DROP'),(23,'GEOMETRYCOLLECTIONFROMWKB'),(24,'EVENTS'),(25,'MONTH'),(26,'INFO'),(27,'PROFILES'),(28,'DUPLICATE'),(29,'REPLICATION'),(30,'UNLOCK'),(31,'INNODB'),(32,'YEAR_MONTH'),(33,'SUBJECT'),(34,'PREPARE'),(35,'LOCK'),(36,'NDB'),(37,'CHECK'),(38,'FULL'),(39,'INT4'),(40,'BY'),(41,'NO'),(42,'MINUTE'),(43,'PARTITION'),(44,'DATA'),(45,'DAY'),(46,'SHARE'),(47,'REAL'),(48,'SEPARATOR'),(49,'MASTER_HEARTBEAT_PERIOD'),(50,'DELETE'),(51,'ON'),(52,'CONNECTION'),(53,'CLOSE'),(54,'X509'),(55,'USE'),(56,'WHERE'),(57,'PRIVILEGES'),(58,'SPATIAL'),(59,'EVENT'),(60,'SUPER'),(61,'SQL_BUFFER_RESULT'),(62,'IGNORE'),(63,'QUICK'),(64,'SIGNED'),(65,'OFFLINE'),(66,'SECURITY'),(67,'AUTOEXTEND_SIZE'),(68,'NDBCLUSTER'),(69,'POLYGONFROMWKB'),(70,'FALSE'),(71,'LEVEL'),(72,'FORCE'),(73,'BINARY'),(74,'TO'),(75,'CHANGE'),(76,'CURRENT_USER'),(77,'HOUR_MINUTE'),(78,'UPDATE'),(79,'PRESERVE'),(80,'INTO'),(81,'FEDERATED'),(82,'VARYING'),(83,'MAX_SIZE'),(84,'HOUR_SECOND'),(85,'VARIABLE'),(86,'ROLLBACK'),(87,'RTREE'),(88,'PROCEDURE'),(89,'TIMESTAMP'),(90,'IMPORT'),(91,'AGAINST'),(92,'CHECKSUM'),(93,'COUNT'),(94,'LONGBINARY'),(95,'THEN'),(96,'INSERT IGNORE'),(97,'ENGINES'),(98,'HANDLER'),(99,'PORT'),(100,'DAY_SECOND'),(101,'EXISTS'),(102,'MUTEX'),(103,'HELP_DATE'),(104,'RELEASE'),(105,'BOOLEAN'),(106,'MOD'),(107,'DEFAULT'),(108,'TYPE'),(109,'NO_WRITE_TO_BINLOG'),(110,'OPTIMIZE'),(111,'RESET'),(112,'ITERATE'),(113,'INSTALL'),(114,'DO'),(115,'BIGINT'),(116,'SET'),(117,'ISSUER'),(118,'DATE'),(119,'STATUS'),(120,'FULLTEXT'),(121,'COMMENT'),(122,'MASTER_CONNECT_RETRY'),(123,'INNER'),(124,'STOP'),(125,'MASTER_LOG_FILE'),(126,'MRG_MYISAM'),(127,'PRECISION'),(128,'REQUIRE'),(129,'TRAILING'),(130,'PARTITIONS'),(131,'LONG'),(132,'OPTION'),(133,'REORGANIZE'),(134,'ELSE'),(135,'DEALLOCATE'),(136,'IO_THREAD'),(137,'CASE'),(138,'CIPHER'),(139,'CONTINUE'),(140,'FROM'),(141,'READ'),(142,'LEFT'),(143,'ELSEIF'),(144,'MINUTE_SECOND'),(145,'COMPACT'),(146,'RESTORE'),(147,'DEC'),(148,'FOR'),(149,'WARNINGS'),(150,'MIN_ROWS'),(151,'CONDITION'),(152,'STRING'),(153,'ENCLOSED'),(154,'FUNCTION'),(155,'AGGREGATE'),(156,'FIELDS'),(157,'INT3'),(158,'ARCHIVE'),(159,'AVG_ROW_LENGTH'),(160,'ADD'),(161,'KILL'),(162,'FLOAT4'),(163,'TABLESPACE'),(164,'VIEW'),(165,'REPEATABLE'),(166,'INFILE'),(167,'HELP_VERSION'),(168,'ORDER'),(169,'USING'),(170,'MIDDLEINT'),(171,'GRANT'),(172,'UNSIGNED'),(173,'DECIMAL'),(174,'GEOMETRYFROMTEXT'),(175,'INDEXES'),(176,'FOREIGN'),(177,'CACHE'),(178,'HOSTS'),(179,'COMMIT'),(180,'SCHEMAS'),(181,'LEADING'),(182,'SNAPSHOT'),(183,'DECLARE'),(184,'LOAD'),(185,'SQL_CACHE'),(186,'CONVERT'),(187,'DYNAMIC'),(188,'COLLATE'),(189,'POLYGONFROMTEXT'),(190,'BYTE'),(191,'GLOBAL'),(192,'LINESTRINGFROMWKB'),(193,'WHEN'),(194,'COLUMN_FORMAT'),(195,'HAVING'),(196,'AS'),(197,'STARTING'),(198,'RELOAD'),(199,'AUTOCOMMIT'),(200,'REVOKE'),(201,'GRANTS'),(202,'OUTER'),(203,'FLOOR'),(204,'EXPLAIN'),(205,'WITH'),(206,'AFTER'),(207,'STD'),(208,'CSV'),(209,'DISABLE'),(210,'UNINSTALL'),(211,'OUTFILE'),(212,'LOW_PRIORITY'),(213,'FILE'),(214,'NODEGROUP'),(215,'SCHEMA'),(216,'SONAME'),(217,'POW'),(218,'DUAL'),(219,'MULTIPOINTFROMWKB'),(220,'INDEX'),(221,'BACKUP'),(222,'MULTIPOINTFROMTEXT'),(223,'DEFINER'),(224,'MASTER_BIND'),(225,'REMOVE'),(226,'EXTENDED'),(227,'MULTILINESTRINGFROMWKB'),(228,'CROSS'),(229,'CONTRIBUTORS'),(230,'NATIONAL'),(231,'GROUP'),(232,'SHA'),(233,'ONLINE'),(234,'UNDO'),(235,'ZEROFILL'),(236,'CLIENT'),(237,'MASTER_PASSWORD'),(238,'OWNER'),(239,'RELAY_LOG_FILE'),(240,'TRUE'),(241,'CHARACTER'),(242,'MASTER_USER'),(243,'TABLE'),(244,'ENGINE'),(245,'INSERT IGNORE_METHOD'),(246,'CASCADE'),(247,'RELAY_LOG_POS'),(248,'SQL_CALC_FOUND_ROWS'),(249,'UNION'),(250,'MYISAM'),(251,'LEAVE'),(252,'MODIFY'),(253,'MATCH'),(254,'MASTER_LOG_POS'),(255,'DISTINCTROW'),(256,'DESC'),(257,'TIME'),(258,'NUMERIC'),(259,'EXPANSION'),(260,'CURSOR'),(261,'CODE'),(262,'GEOMETRYCOLLECTIONFROMTEXT'),(263,'CHAIN'),(264,'LOGFILE'),(265,'FLUSH'),(266,'CREATE'),(267,'DESCRIBE'),(268,'EXTENT_SIZE'),(269,'MAX_UPDATES_PER_HOUR'),(270,'INT2'),(271,'PROCESSLIST'),(272,'ENDS'),(273,'LOGS'),(274,'DISCARD'),(275,'HEAP'),(276,'SOUNDS'),(277,'BETWEEN'),(278,'MULTILINESTRINGFROMTEXT'),(279,'REPAIR'),(280,'PACK_KEYS'),(281,'FAST'),(282,'VALUES'),(283,'CALL'),(284,'LOOP'),(285,'VARCHARACTER'),(286,'BEFORE'),(287,'TRUNCATE'),(288,'SHOW'),(289,'ALL'),(290,'REDUNDANT'),(291,'USER_RESOURCES'),(292,'PARTIAL'),(293,'BINLOG'),(294,'END'),(295,'SECOND'),(296,'AND'),(297,'FLOAT8'),(298,'PREV'),(299,'HOUR'),(300,'SELECT'),(301,'DATABASES'),(302,'OR'),(303,'IDENTIFIED'),(304,'WRAPPER'),(305,'MASTER_SSL_CIPHER'),(306,'SQL_SLAVE_SKIP_COUNTER'),(307,'BOTH'),(308,'BOOL'),(309,'YEAR'),(310,'MASTER_PORT'),(311,'CONCURRENT'),(312,'HELP'),(313,'UNIQUE'),(314,'TRIGGERS'),(315,'PROCESS'),(316,'OPTIONS'),(317,'CONSISTENT'),(318,'MASTER_SSL'),(319,'DATE_ADD'),(320,'MAX_CONNECTIONS_PER_HOUR'),(321,'LIKE'),(322,'PLUGIN'),(323,'FETCH'),(324,'IN'),(325,'COLUMN'),(326,'DUMPFILE'),(327,'USAGE'),(328,'EXECUTE'),(329,'MEMORY'),(330,'CEIL'),(331,'QUERY'),(332,'MASTER_HOST'),(333,'LINES'),(334,'SQL_THREAD'),(335,'SERVER'),(336,'MAX_QUERIES_PER_HOUR'),(337,'MASTER_SSL_CERT'),(338,'MULTIPOLYGONFROMWKB'),(339,'TRANSACTION'),(340,'DAY_MINUTE'),(341,'STDDEV'),(342,'DATE_SUB'),(343,'REBUILD'),(344,'GEOMETRYFROMWKB'),(345,'INT1'),(346,'RENAME'),(347,'PARSER'),(348,'RIGHT'),(349,'ALTER'),(350,'MAX_ROWS'),(351,'SOCKET'),(352,'STRAIGHT_JOIN'),(353,'NATURAL'),(354,'VARIABLES'),(355,'ESCAPED'),(356,'SHA1'),(357,'KEY_BLOCK_SIZE'),(358,'PASSWORD'),(359,'OFFSET'),(360,'CHAR'),(361,'NEXT'),(362,'SQL_LOG_BIN'),(363,'ERRORS'),(364,'TEMPORARY'),(365,'COMMITTED'),(366,'SQL_SMALL_RESULT'),(367,'UPGRADE'),(368,'BEGIN'),(369,'DELAY_KEY_WRITE'),(370,'PROFILE'),(371,'MEDIUM'),(372,'INTERVAL'),(373,'SSL'),(374,'DAY_HOUR'),(375,'NAME'),(376,'REFERENCES'),(377,'AES_ENCRYPT'),(378,'STORAGE'),(379,'ISOLATION'),(380,'CEILING'),(381,'EVERY'),(382,'INT8'),(383,'AUTHORS'),(384,'RESTRICT'),(385,'UNCOMMITTED'),(386,'LINESTRINGFROMTEXT'),(387,'IS'),(388,'NOT'),(389,'ANALYSE'),(390,'DATAFILE'),(391,'DES_KEY_FILE'),(392,'COMPRESSED'),(393,'START'),(394,'PLUGINS'),(395,'SAVEPOINT'),(396,'IF'),(397,'PRIMARY'),(398,'PURGE'),(399,'LAST'),(400,'USER'),(401,'INNOBASE'),(402,'EXIT'),(403,'KEYS'),(404,'LIMIT'),(405,'KEY'),(406,'MERGE'),(407,'UNTIL'),(408,'SQL_NO_CACHE'),(409,'DELAYED'),(410,'ANALYZE'),(411,'CONSTRAINT'),(412,'SERIAL'),(413,'ACTION'),(414,'WRITE'),(415,'INITIAL_SIZE'),(416,'SESSION'),(417,'DATABASE'),(418,'NULL'),(419,'POWER'),(420,'USE_FRM'),(421,'TERMINATED'),(422,'SLAVE'),(423,'NVARCHAR'),(424,'ASC'),(425,'RETURN'),(426,'OPTIONALLY'),(427,'ENABLE'),(428,'DIRECTORY'),(429,'WHILE'),(430,'MAX_USER_CONNECTIONS'),(431,'LOCAL'),(432,'DISTINCT'),(433,'AES_DECRYPT'),(434,'MASTER_SSL_KEY'),(435,'NONE'),(436,'TABLES'),(437,'<>'),(438,'RLIKE'),(439,'TRIGGER'),(440,'COLLATION'),(441,'SHUTDOWN'),(442,'HIGH_PRIORITY'),(443,'BTREE'),(444,'FIRST'),(445,'COALESCE'),(446,'WAIT'),(447,'TYPES'),(448,'MASTER'),(449,'FIXED'),(450,'MULTIPOLYGONFROMTEXT'),(451,'ROW_FORMAT');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT IGNORE INTO `help_relation` VALUES (1,0),(355,0),(471,1),(230,2),(447,3),(3,4),(422,4),(87,5),(87,6),(407,6),(95,7),(87,8),(185,9),(430,10),(21,11),(346,11),(422,11),(461,11),(87,12),(407,12),(144,13),(228,14),(86,15),(355,15),(16,16),(104,16),(131,16),(346,16),(95,17),(498,17),(380,18),(3,19),(102,19),(241,19),(185,20),(355,21),(9,22),(30,22),(34,22),(85,22),(186,22),(235,22),(262,22),(275,22),(299,22),(330,22),(406,22),(416,22),(417,22),(461,22),(476,22),(106,23),(121,24),(168,24),(376,25),(258,26),(80,27),(102,28),(199,29),(36,30),(346,31),(401,31),(466,31),(376,32),(199,33),(35,34),(235,34),(36,35),(355,35),(466,36),(418,37),(461,37),(466,37),(21,38),(293,38),(346,38),(451,38),(466,38),(498,39),(48,40),(75,40),(81,40),(199,40),(355,40),(362,40),(422,40),(461,40),(466,40),(466,41),(470,41),(376,42),(461,43),(466,43),(117,44),(211,44),(422,44),(466,44),(471,44),(376,45),(355,46),(95,47),(313,47),(362,48),(185,49),(48,50),(466,50),(470,50),(1,51),(87,51),(407,51),(470,51),(174,52),(466,52),(51,53),(104,53),(199,54),(1,55),(55,55),(193,55),(48,56),(81,56),(104,56),(192,57),(199,57),(247,57),(209,58),(461,58),(87,59),(299,59),(357,59),(407,59),(199,60),(355,61),(1,62),(81,62),(102,62),(355,62),(422,62),(461,62),(48,63),(418,63),(464,63),(228,64),(85,65),(209,65),(461,65),(199,66),(193,67),(466,68),(89,69),(480,69),(385,70),(447,71),(1,72),(39,73),(228,73),(268,73),(185,74),(268,74),(459,74),(185,75),(461,75),(87,76),(407,76),(376,77),(81,78),(102,78),(355,78),(470,78),(87,79),(407,79),(3,80),(102,80),(303,80),(355,80),(466,81),(255,82),(193,83),(376,84),(128,85),(144,86),(459,86),(209,87),(18,88),(184,88),(301,88),(327,88),(346,88),(355,88),(417,88),(439,88),(486,88),(97,89),(188,89),(422,90),(461,90),(86,91),(402,92),(466,92),(67,93),(329,93),(433,93),(284,94),(28,95),(57,95),(83,95),(102,96),(194,96),(300,96),(484,96),(281,97),(346,97),(104,98),(312,98),(471,99),(376,100),(9,101),(30,101),(87,101),(153,101),(186,101),(275,101),(299,101),(346,102),(366,102),(107,103),(144,104),(459,104),(24,105),(86,105),(111,106),(173,106),(3,107),(102,107),(153,107),(198,107),(211,107),(241,107),(461,107),(466,107),(461,108),(113,109),(326,109),(464,109),(468,109),(113,110),(461,110),(38,111),(118,111),(149,111),(263,111),(123,112),(420,113),(87,114),(124,114),(407,114),(494,114),(220,115),(3,116),(81,116),(102,116),(128,116),(137,116),(144,116),(153,116),(181,116),(211,116),(332,116),(346,116),(355,116),(422,116),(461,116),(466,116),(470,116),(475,116),(492,116),(199,117),(130,118),(228,118),(261,118),(376,118),(58,119),(134,119),(214,119),(222,119),(327,119),(335,119),(346,119),(366,119),(401,119),(209,120),(461,120),(466,120),(87,121),(193,121),(407,121),(466,121),(185,122),(1,123),(52,124),(185,125),(466,126),(313,127),(199,128),(455,129),(253,130),(284,131),(199,132),(247,132),(461,133),(57,134),(83,134),(235,135),(52,136),(323,136),(57,137),(83,137),(199,138),(312,139),(48,140),(117,140),(121,140),(346,140),(355,140),(360,140),(455,140),(36,141),(104,141),(447,141),(1,142),(28,143),(376,144),(466,145),(178,146),(208,147),(179,148),(312,148),(346,148),(355,148),(421,148),(329,149),(346,149),(466,150),(179,151),(95,152),(422,153),(34,154),(66,154),(95,154),(210,154),(231,154),(301,154),(335,154),(346,154),(393,154),(406,154),(417,154),(95,155),(346,156),(422,156),(250,157),(466,158),(461,159),(466,159),(60,160),(193,160),(461,160),(476,160),(174,161),(166,162),(193,163),(416,163),(461,163),(476,163),(30,164),(157,164),(454,164),(447,165),(422,166),(189,167),(48,168),(81,168),(355,168),(362,168),(461,168),(1,169),(48,169),(84,169),(250,170),(199,171),(247,171),(24,172),(127,172),(166,172),(208,172),(228,172),(313,172),(498,172),(95,173),(154,173),(228,173),(412,174),(346,175),(461,176),(466,176),(470,176),(471,176),(99,177),(149,177),(303,177),(143,178),(346,178),(144,179),(158,180),(346,180),(455,181),(144,182),(179,183),(198,183),(312,183),(421,183),(117,184),(303,184),(360,184),(422,184),(355,185),(228,186),(377,186),(466,187),(153,188),(211,188),(466,188),(395,189),(463,190),(128,191),(134,191),(181,191),(348,191),(447,191),(452,192),(57,193),(83,193),(466,194),(355,195),(1,196),(36,196),(355,196),(422,197),(199,198),(144,199),(247,200),(191,201),(346,201),(1,202),(220,203),(253,204),(86,205),(199,205),(209,205),(461,205),(466,205),(461,206),(259,207),(422,208),(466,208),(87,209),(407,209),(461,209),(290,210),(355,211),(3,212),(36,212),(48,212),(81,212),(102,212),(422,212),(199,213),(193,214),(153,215),(186,215),(211,215),(308,215),(346,215),(95,216),(276,217),(278,218),(462,219),(1,220),(60,220),(85,220),(99,220),(209,220),(303,220),(307,220),(346,220),(461,220),(466,220),(358,221),(425,222),(87,223),(407,223),(185,224),(461,225),(253,226),(464,226),(271,227),(1,228),(7,229),(346,229),(255,230),(430,230),(193,231),(225,231),(355,231),(427,232),(85,233),(209,233),(461,233),(312,234),(24,235),(127,235),(166,235),(208,235),(313,235),(498,235),(199,236),(185,237),(471,238),(185,239),(385,240),(153,241),(211,241),(255,241),(332,241),(346,241),(355,241),(422,241),(430,241),(466,241),(185,242),(60,243),(108,243),(113,243),(178,243),(214,243),(275,243),(277,243),(320,243),(346,243),(358,243),(360,243),(402,243),(418,243),(461,243),(464,243),(466,243),(468,243),(193,244),(346,244),(366,244),(416,244),(461,244),(466,244),(476,244),(466,245),(30,246),(275,246),(466,246),(470,246),(185,247),(355,248),(304,249),(466,250),(309,251),(461,252),(86,253),(185,254),(355,255),(328,256),(355,256),(362,256),(228,257),(314,257),(375,257),(208,258),(86,259),(421,260),(66,261),(486,261),(244,262),(144,263),(193,264),(225,264),(149,265),(326,265),(18,266),(22,266),(60,266),(75,266),(87,266),(95,266),(153,266),(193,266),(209,266),(210,266),(277,266),(301,266),(308,266),(346,266),(357,266),(393,266),(454,266),(466,266),(471,266),(328,267),(193,268),(199,269),(232,270),(346,271),(451,271),(87,272),(39,273),(268,273),(346,273),(461,274),(466,275),(378,276),(145,277),(105,278),(461,279),(464,279),(466,280),(418,281),(3,282),(102,282),(338,283),(343,284),(255,285),(268,286),(320,287),(7,288),(10,288),(18,288),(21,288),(25,288),(33,288),(39,288),(58,288),(66,288),(67,288),(80,288),(121,288),(131,288),(134,288),(143,288),(158,288),(168,288),(191,288),(192,288),(214,288),(222,288),(277,288),(281,288),(293,288),(307,288),(308,288),(327,288),(329,288),(332,288),(335,288),(346,288),(348,288),(357,288),(366,288),(393,288),(401,288),(451,288),(485,288),(486,288),(490,288),(199,289),(247,289),(304,289),(355,289),(466,290),(326,291),(466,292),(121,293),(349,293),(28,294),(57,294),(83,294),(230,294),(325,294),(343,294),(494,294),(376,295),(145,296),(315,296),(313,297),(104,298),(376,299),(3,300),(102,300),(253,300),(258,300),(300,300),(355,300),(158,301),(346,301),(139,302),(75,303),(199,303),(471,304),(185,305),(181,306),(455,307),(24,308),(109,308),(376,309),(185,310),(422,311),(116,312),(390,312),(461,313),(25,314),(346,314),(199,315),(374,316),(471,316),(144,317),(185,318),(376,319),(199,320),(346,321),(378,321),(290,322),(346,322),(420,322),(383,323),(86,324),(121,324),(355,324),(461,325),(355,326),(199,327),(84,328),(199,328),(355,329),(397,330),(86,331),(149,331),(174,331),(185,332),(422,333),(52,334),(323,334),(9,335),(374,335),(471,335),(199,336),(185,337),(122,338),(144,339),(447,339),(376,340),(408,341),(376,342),(461,343),(142,344),(24,345),(108,346),(221,346),(407,346),(461,346),(209,347),(461,347),(466,347),(1,348),(60,349),(157,349),(199,349),(211,349),(225,349),(231,349),(374,349),(407,349),(439,349),(461,349),(476,349),(466,350),(471,351),(1,352),(355,352),(1,353),(346,354),(348,354),(422,355),(427,356),(466,357),(75,358),(199,358),(471,358),(475,358),(355,359),(228,360),(463,360),(104,361),(492,362),(67,363),(346,363),(275,364),(447,365),(355,366),(211,367),(418,367),(144,368),(325,368),(466,369),(485,370),(418,371),(87,372),(376,372),(199,373),(376,374),(211,375),(199,376),(466,376),(470,376),(443,377),(281,378),(447,379),(448,380),(87,381),(127,382),(10,383),(346,383),(30,384),(275,384),(470,384),(447,385),(56,386),(82,387),(205,387),(369,387),(456,387),(82,388),(87,388),(153,388),(205,388),(311,388),(184,389),(193,390),(476,390),(326,391),(466,392),(144,393),(323,393),(33,394),(459,395),(9,396),(28,396),(30,396),(87,396),(153,396),(186,396),(275,396),(299,396),(477,396),(461,397),(268,398),(104,399),(75,400),(221,400),(330,400),(471,400),(466,401),(312,402),(307,403),(346,403),(461,403),(48,404),(81,404),(104,404),(121,404),(355,404),(60,405),(102,405),(461,405),(466,405),(470,405),(466,406),(230,407),(355,408),(3,409),(102,409),(484,409),(461,410),(468,410),(461,411),(466,411),(241,412),(466,412),(466,413),(470,413),(36,414),(193,415),(476,415),(128,416),(134,416),(348,416),(447,416),(153,417),(186,417),(211,417),(308,417),(346,417),(471,417),(82,418),(369,418),(470,418),(481,419),(464,420),(422,421),(38,422),(52,422),(87,422),(143,422),(222,422),(323,422),(407,422),(255,423),(355,424),(362,424),(489,425),(422,426),(87,427),(407,427),(461,427),(211,428),(466,428),(494,429),(199,430),(36,431),(113,431),(326,431),(422,431),(464,431),(468,431),(0,432),(94,432),(287,432),(304,432),(355,432),(362,432),(384,432),(433,432),(495,433),(185,434),(199,435),(36,436),(131,436),(293,436),(346,436),(493,437),(27,438),(22,439),(262,439),(346,439),(346,440),(490,440),(199,441),(102,442),(355,442),(209,443),(104,444),(461,444),(466,444),(461,445),(193,446),(476,446),(346,447),(39,448),(58,448),(117,448),(185,448),(263,448),(268,448),(360,448),(208,449),(466,449),(200,450),(466,451);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` char(128) NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
/*!40000 ALTER TABLE `help_topic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `host`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `host` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Host privileges;  Merged with database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `host`
--

LOCK TABLES `host` WRITE;
/*!40000 ALTER TABLE `host` DISABLE KEYS */;
/*!40000 ALTER TABLE `host` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ndb_binlog_index`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ndb_binlog_index` (
  `Position` bigint(20) unsigned NOT NULL,
  `File` varchar(255) NOT NULL,
  `epoch` bigint(20) unsigned NOT NULL,
  `inserts` bigint(20) unsigned NOT NULL,
  `updates` bigint(20) unsigned NOT NULL,
  `deletes` bigint(20) unsigned NOT NULL,
  `schemaops` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`epoch`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ndb_binlog_index`
--

LOCK TABLES `ndb_binlog_index` WRITE;
/*!40000 ALTER TABLE `ndb_binlog_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `ndb_binlog_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plugin`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `plugin` (
  `name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `dl` char(128) COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='MySQL plugins';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plugin`
--

LOCK TABLES `plugin` WRITE;
/*!40000 ALTER TABLE `plugin` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `proc`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `proc` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `type` enum('FUNCTION','PROCEDURE') NOT NULL,
  `specific_name` char(64) NOT NULL DEFAULT '',
  `language` enum('SQL') NOT NULL DEFAULT 'SQL',
  `sql_data_access` enum('CONTAINS_SQL','NO_SQL','READS_SQL_DATA','MODIFIES_SQL_DATA') NOT NULL DEFAULT 'CONTAINS_SQL',
  `is_deterministic` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `security_type` enum('INVOKER','DEFINER') NOT NULL DEFAULT 'DEFINER',
  `param_list` blob NOT NULL,
  `returns` longblob NOT NULL,
  `body` longblob NOT NULL,
  `definer` char(77) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','NOT_USED','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob,
  PRIMARY KEY (`db`,`name`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Stored Procedures';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proc`
--

LOCK TABLES `proc` WRITE;
/*!40000 ALTER TABLE `proc` DISABLE KEYS */;
/*!40000 ALTER TABLE `proc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `procs_priv`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `procs_priv` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(16) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Routine_name` char(64) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `Routine_type` enum('FUNCTION','PROCEDURE') COLLATE utf8_bin NOT NULL,
  `Grantor` char(77) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Proc_priv` set('Execute','Alter Routine','Grant') CHARACTER SET utf8 NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`Host`,`Db`,`User`,`Routine_name`,`Routine_type`),
  KEY `Grantor` (`Grantor`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Procedure privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `procs_priv`
--

LOCK TABLES `procs_priv` WRITE;
/*!40000 ALTER TABLE `procs_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `procs_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `servers` (
  `Server_name` char(64) NOT NULL DEFAULT '',
  `Host` char(64) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `Username` char(64) NOT NULL DEFAULT '',
  `Password` char(64) NOT NULL DEFAULT '',
  `Port` int(4) NOT NULL DEFAULT '0',
  `Socket` char(64) NOT NULL DEFAULT '',
  `Wrapper` char(64) NOT NULL DEFAULT '',
  `Owner` char(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`Server_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='MySQL Foreign Servers table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers`
--

LOCK TABLES `servers` WRITE;
/*!40000 ALTER TABLE `servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tables_priv`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `tables_priv` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(16) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Table_name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Grantor` char(77) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Table_priv` set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter','Create View','Show view','Trigger') CHARACTER SET utf8 NOT NULL DEFAULT '',
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`),
  KEY `Grantor` (`Grantor`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Table privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tables_priv`
--

LOCK TABLES `tables_priv` WRITE;
/*!40000 ALTER TABLE `tables_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `tables_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `time_zone` (
  `Time_zone_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Use_leap_seconds` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Time_zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Time zones';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone`
--

LOCK TABLES `time_zone` WRITE;
/*!40000 ALTER TABLE `time_zone` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone_leap_second`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `time_zone_leap_second` (
  `Transition_time` bigint(20) NOT NULL,
  `Correction` int(11) NOT NULL,
  PRIMARY KEY (`Transition_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Leap seconds information for time zones';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone_leap_second`
--

LOCK TABLES `time_zone_leap_second` WRITE;
/*!40000 ALTER TABLE `time_zone_leap_second` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone_leap_second` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone_name`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `time_zone_name` (
  `Name` char(64) NOT NULL,
  `Time_zone_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Time zone names';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone_name`
--

LOCK TABLES `time_zone_name` WRITE;
/*!40000 ALTER TABLE `time_zone_name` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone_name` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone_transition`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `time_zone_transition` (
  `Time_zone_id` int(10) unsigned NOT NULL,
  `Transition_time` bigint(20) NOT NULL,
  `Transition_type_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`Time_zone_id`,`Transition_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Time zone transitions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone_transition`
--

LOCK TABLES `time_zone_transition` WRITE;
/*!40000 ALTER TABLE `time_zone_transition` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone_transition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone_transition_type`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `time_zone_transition_type` (
  `Time_zone_id` int(10) unsigned NOT NULL,
  `Transition_type_id` int(10) unsigned NOT NULL,
  `Offset` int(11) NOT NULL DEFAULT '0',
  `Is_DST` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `Abbreviation` char(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`Time_zone_id`,`Transition_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Time zone transition types';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone_transition_type`
--

LOCK TABLES `time_zone_transition_type` WRITE;
/*!40000 ALTER TABLE `time_zone_transition_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone_transition_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ttt`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ttt` (
  `Host` char(60) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(16) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `Password` char(41) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Reload_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Shutdown_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Process_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `File_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Show_db_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Super_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Repl_slave_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Repl_client_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Create_user_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') NOT NULL DEFAULT 'N',
  `ssl_type` enum('','ANY','X509','SPECIFIED') NOT NULL DEFAULT '',
  `ssl_cipher` blob NOT NULL,
  `x509_issuer` blob NOT NULL,
  `x509_subject` blob NOT NULL,
  `max_questions` int(11) unsigned NOT NULL DEFAULT '0',
  `max_updates` int(11) unsigned NOT NULL DEFAULT '0',
  `max_connections` int(11) unsigned NOT NULL DEFAULT '0',
  `max_user_connections` int(11) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ttt`
--

LOCK TABLES `ttt` WRITE;
/*!40000 ALTER TABLE `ttt` DISABLE KEYS */;
INSERT IGNORE INTO `ttt` VALUES ('localhost','bmclient','','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0);
/*!40000 ALTER TABLE `ttt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `user` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(16) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Password` char(41) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Reload_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Shutdown_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Process_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `File_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Show_db_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Super_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Repl_slave_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Repl_client_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_user_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `ssl_type` enum('','ANY','X509','SPECIFIED') CHARACTER SET utf8 NOT NULL DEFAULT '',
  `ssl_cipher` blob NOT NULL,
  `x509_issuer` blob NOT NULL,
  `x509_subject` blob NOT NULL,
  `max_questions` int(11) unsigned NOT NULL DEFAULT '0',
  `max_updates` int(11) unsigned NOT NULL DEFAULT '0',
  `max_connections` int(11) unsigned NOT NULL DEFAULT '0',
  `max_user_connections` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`Host`,`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT IGNORE INTO `user` VALUES ('localhost','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0),('bmadaptive01e','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0),('127.0.0.1','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0),('localhost','debian-sys-maint','*B3FBA85D0E23B4160453B53898154F133234663C','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0),('localhost','bmclient','','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0),('127.0.0.1','bmclient','','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0),('178.154.224.228','rplcat','*D5E7B5AB98EB6E5467EF9675EF41E521D3D665E7','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','Y','N','N','N','N','N','N','N','N','','','','',0,0,0,0),('bmfront01f.yandex.ru','bmclient','','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0),('localhost','advmon','*050376F3855A67F5E2C6514FD3130B31006C1276','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','Y','N','N','N','Y','N','N','N','N','N','N','N','N','','','','',0,0,0,0);
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2014-03-13 11:29:33
