#!/bin/bash
set -e
set -x

branch=bm-common
torepo=stable

debuild
dh_clean

pkg=$(basename $(readlink -f $(dirname $0)))
changes=$(ls -1 ../$pkg*.changes | tail -1)
version=$(echo $changes | cut -d'_' -f 2)

dupload -t $branch $changes
if [ "$torepo" != "unstable" ]; then
	echo "WAIT SOME TIME WHITE dist IS DIGESTING UPLOADED PACKAGE"
	sleep 10
	ssh dist sudo dmove $branch $torepo $pkg $version unstable
fi

