#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";

use Utils::Common;
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    fork_tasks
    rotate_files
    handle_errors
);
use Utils::Hosts qw(get_curr_host);
use Project;

get_file_lock() or exit(0);
handle_errors();

my $proj = Project->new({
    load_dicts => 1, load_minicategs_light => 1, load_languages => ["ru", "en", "tr"]
});
$proj->categs_tree->never_write_categs_cache(1);
$proj->categs_tree->never_read_categs_cache(1);
$proj->banners_categories->export_mediagroups;
$proj->banners_categories->export_interests_mapping;
$proj->banners_categories->upload_data_to_yt;

release_file_lock();
exit(0);
