#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;


handle_errors;

my $proj = Project->new({});
my $curr = $proj->distr_banners_bender->get_current_host_server;
die("this is not a bender server") if !$curr;

# если файла с данными нет, выходим
unless(-e $curr->binary_file) {
    $proj->log("no data file, do exit");
    exit(0);
}

if(fork()) {
    exit(0);
} else {
    get_file_lock("banners-bender-server") or print_err("found already running script, do exit") and exit(0);

    # запуск сервера
    $proj->do_sys_cmd(join " ",
        "LD_PRELOAD=\"/usr/lib/libtcmalloc_minimal.so.4\"",
        $curr->server_dir . "/bender", 
        "--port=".$curr->port,
        "--binary-file=".$curr->binary_file
    );

    release_file_lock("banners-bender-server") or print_err("found already running script, do exit") and exit(0);
}
