#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Sys qw/
    get_file_lock release_file_lock
    handle_errors
    print_err
/;

get_file_lock("bender-banners-stop-server") or print_err("found already running script, do exit") and exit(0);

handle_errors;

my $proj = Project->new({});

my $curr = $proj->distr_banners_bender->get_current_host_server;

die("this is not a bender server") if !$curr;

$curr->exec_command_once("stop");

release_file_lock("bender-banners-stop-server") or print_err("found already running script, do exit") and exit(0);

