#!/usr/bin/perl -w
use strict;

use utf8;
use open ":utf8";

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../wlib";
use CatalogiaMediaProject;

use Getopt::Long;
use BM::Phrase;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

get_file_lock("generate_categs_tree") or print_err("found already running script, do exit") and exit(0);

handle_errors;


my $proj = CatalogiaMediaProject->new({load_dicts => 1, load_minicategs_light => 1, no_form => 1, no_auth => 1, nrmsrv => 0, });

#Категории

my $fn_temp = $Utils::Common::options->{dirs}{temp}."/categs_tree";
open F, "> $fn_temp" or die;
print F join("\t", @$_)."\n" for $proj->categs_tree->generate_categs_tree;
close F;

$proj->do_sys_cmd("mv $fn_temp ".$Utils::Common::options->{categs_tree_report});

#Медиагруппы

my $fn_temp2 = $Utils::Common::options->{dirs}{temp}."/mediagroups_tree";
open F, "> $fn_temp2" or die;
print F map {join("\t", @$_)."\n"} 
#    grep {!( $_->[0] && $_->[1] && $_->[2] && $_->[3] )}
    $proj->mediagroups->generate_groups_tree;
#map { [ 
#    @{$_}{qw{ mediagroup categ }}, 
#    md5int( $_->{mediagroup} ), 
#    $ct->get_minicateg_directid($_->{categ}), 
#] } map {@$_} $proj->List_SQL('select mediagroup, categ from categs_mediagroups');
close F;

$proj->do_sys_cmd("mv $fn_temp2 ".$Utils::Common::options->{mediagroups_tree_report});

release_file_lock("generate_categs_tree");

