#!/usr/bin/perl -w
use strict;

use utf8;
use open ":utf8";

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../wlib";
use Project;

use Getopt::Long;
use BM::Phrase;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_err
    handle_errors
    get_tempfile
/;

get_file_lock("upload_categs_tree_to_yt") or print_err("found already running script, do exit") and exit(0);

handle_errors;


my $proj = Project->new({
    load_dicts => 1,
    load_minicategs_light => 1,
});
my $categs_tree = $proj->categs_tree;

my $tmp_file = get_tempfile('categories_info', UNLINK => 1);

open(my $fh, ">", $tmp_file);
print $fh join("\t", "ALL", "ALL", "", 0, 0, "") . "\n";
for my $category ($categs_tree->get_minicategs_list()) {
    if ($category =~ /^(\!|\.)/) {
        next;
    }
    my $parent_category = $categs_tree->get_minicateg_parent($category) || 'ALL';
    print $fh join("\t",
        $category,
        $parent_category,
        $categs_tree->get_minicateg_id($category),
        int($categs_tree->get_minicateg_directid($category)),
        int($categs_tree->get_minicateg_directid($parent_category)),
        join(",", keys %{$categs_tree->get_minicateg_flags($category)}),
    ) . "\n";
}
close($fh);


$proj->yt_client->write_tsv_file(
   $tmp_file,
   '//home/catalogia/categories_tree',
   ['Category', 'ParentCategory', 'CategoryID', 'DirectID', 'DirectParentID', 'Flags'],
   ['string', 'string', 'string', 'uint64', 'uint64', 'string'],
);

release_file_lock("upload_categs_tree_to_yt");
