# -*- coding: utf-8 -*-
import gzip
from os import path, makedirs
from shutil import rmtree
import subprocess
import sys
import irt.iron.options as iron_opts
from time import sleep
from api.copier import Copier
from sandbox.common import rest
from sandbox.common.auth import OAuth

import irt.broadmatching.common_options


def do_queries(queries_list, mysql_script_args):
    sp = subprocess.Popen(mysql_script_args, stdin=subprocess.PIPE, stderr=subprocess.PIPE)
    perl_stdout, perl_stderr = sp.communicate("\n".join(queries_list))
    sys.stderr.write(perl_stderr)
    if -1 != perl_stderr.find("ERROR"):
        raise RuntimeError("MySQL error")
    if sp.returncode:
        raise RuntimeError("{} return non-zero status: {}!".format(mysql_script_args[0], sp.returncode))
    sleep(3)


def apply_patch():
    diff_sb_resource_type = iron_opts.get("campaigns_mysql_diff_sb_resource_type")
    temp_dir = path.join(path.abspath(irt.broadmatching.common_options.get_options()["dirs"]["temp"]), "sandbox2mysql")
    rmtree(temp_dir, ignore_errors=True)
    makedirs(temp_dir)
    # считываем информацию о наиболее свежем ресурсе из sandbox, если в sandbox вообще нет такого ресурса, то будет keyerror, ну и хорошо
    with open(iron_opts.get("sandbox_token_path")) as f:
        token = f.readline().strip()
    sandbox = rest.Client(auth=OAuth(token))
    response = sandbox.resource.read(state="READY", order=["-id"], type="IRT_DATA", owner="IRT", limit=1, attrs={"sub_type": diff_sb_resource_type, "patch_status": "new"})
    skynet_id = response["items"][0]["skynet_id"]
    # Скачиваем skynet'ом, во временный каталог сваливается дерево с каталогами и файлами
    Copier().handle(skynet_id).get(dest=temp_dir).wait()
    # разбиваем на куски по 1000 запросов и передаем их в MySQL с небольшой паузой между пачками
    queries_list = []
    mysql_script_args = [path.join(path.abspath(irt.broadmatching.common_options.get_options()['dirs']['scripts']), "utils", "connect-dbh.pl"), "catalogia_media_dbh"]
    with gzip.open(path.join(temp_dir, diff_sb_resource_type, "rt-research", "broadmatching", "work", "DbUploader", "diff_Campaigns.gz"), "r") as queries:
        for query in queries:
            queries_list.append(query)
            if (len(queries_list) == 1000):
                do_queries(queries_list, mysql_script_args)
                queries_list = []
    do_queries(queries_list, mysql_script_args)
    # вроде все прошло благополучно, отмечаем ресурс в sandbox как применённый
    resource_id = response["items"][0]["id"]
    sandbox.resource[resource_id].attribute['patch_status'].update({'value': 'applied'})


def main():
    apply_patch()


if __name__ == "__main__":
    main()
