#!/usr/bin/env perl

use strict;
use warnings;

use Getopt::Long;
use FindBin;
use lib "$FindBin::Bin/lib";

use BM::Bootstrap qw/get_bootstrap/;

my %opt;
GetOptions(\%opt, 'uncompressed', 'local', 'help');

if (!@ARGV or $opt{help}) {
    printf "Usage: $0 name1 name2 ...\n";
    printf "Get required bootstraps; choose from list:\n";
    for my $name (BM::Bootstrap::list_bootstraps()) {
        printf "  %s\n", $name;
    }
    printf "Options:\n";
    printf "  --uncompressed    dont gzip tarball\n";
    printf "  --local           dont get rsync resources\n";
    exit;
}

my %par;
$par{uncompressed} = 1 if $opt{uncompressed};
$par{dont_get_rsync_resources} = 1 if $opt{local};

for my $name (@ARGV) {
    print get_bootstrap($name, %par);
    print "\n";
}
