#!/usr/bin/perl -w

use open ':utf8';
use utf8;

use Data::Dumper;

use FindBin;
use lib "$FindBin::Bin/../lib";

use Utils::Sys qw(
    get_file_lock
    release_file_lock
    handle_errors
    mtime
    print_log
);
use Utils::Hosts qw(get_curr_host);
use Utils::Common;
use BM::Monitor::Utils qw[ check_cache_status ];
use Project;
use BM::SolomonClient;

handle_errors();

get_file_lock()  or exit(0);
    
my $proj = Project->new({});
my $solomon_client = BM::SolomonClient->new();
my $host = get_curr_host();

my %res_metrics;

{
    for my $ls (
        "ls -l  ",
        "ls -lst",
    ) {
        my $res = `$ls /opt/broadmatching/work/kystorage.kch`;
        chomp $res;
        print_log("$ls: $res");
    }

    my $res = `ls -l /opt/broadmatching/work/kystorage.kch`;
    my ($size) = $res =~ m/\sbmclient\s+bmclient\s+(\d+)/;
    $res_metrics{kystorage_file_size} = $size;
}

my $ktserver_pid_file = '/opt/broadmatching/lock/ktserver.pid';
my $pid = `[[ -f $ktserver_pid_file ]] && cat $ktserver_pid_file`;
chomp $pid;
print_log("pid: $pid");
if ($pid) {
    my $cmd = "ps axf --format pid,ppid,user,pmem,vsz,rss,lstart,args | grep -P '^ *$pid .* bmclient .* ktserver ' | grep ktserver | grep -v grep";
    print_log("cmd: $cmd");
    my @ps = `$cmd`;
    if (@ps) {
        print_log("ps: @ps");
    }
}

if (0) { # temporary off
    my @netstat_cc_hosts = map { chomp; $_ } `netstat -ap | grep 'bmcache01..yandex.:1115' | awk '{print \$5}' | sed 's/[0-9:].*//' | sort | uniq -c`;
    print_log("netstat_cc_hosts: @netstat_cc_hosts");
    my $netstat_cc = 0;
    $netstat_cc += (m/^ *(\d+)/)[0]   for @netstat_cc_hosts;
    print_log("netstat_cc: $netstat_cc");
}

{
    for my $opt_name (qw[ kyoto broad_kyoto ]) {
        my $servers = $Utils::Common::options->{$opt_name}{servers};
        if (grep { m/^$host/ } map { $_->{address} } @$servers) {
            my $cache_name =
                $opt_name eq 'broad_kyoto' ? 'broad_kyoto'
                : $opt_name eq 'kyoto' ? 'ktclient'
                : '';
            my $client = $proj->$cache_name;

            my $status = check_cache_status($client);
            $proj->log("check_cache_status($cache_name): $status");

            $res_metrics{status} = $status;
        }
    }
}

$proj->log("Send metrics to Solomon...");
for my $key (
    'kystorage_file_size',
    'status',
) {
    my $value = $res_metrics{$key} // next;
    $solomon_client->push_single_sensor({
        cluster => "host_info",
        service => "ktserver",
        sensor  => $key,
        labels  => {
            host   => $host,
        },
        value   => $value,
    });

}

exit(0);

