#!/usr/bin/perl -w

use open ':utf8';
use utf8;

use FindBin;
use lib "$FindBin::Bin/../lib";

use Utils::Sys qw(
    get_file_lock
    wait_for_file_lock
    handle_errors
    mtime
    print_log
    do_safely
);
use Data::Dumper;

handle_errors();

my $ktserver_pid_file = '/opt/broadmatching/lock/ktserver.pid';

my $need_restart;
if (grep { $_ eq '--restart' } @ARGV) {
    print_log("Force restart");
    $need_restart = 1;

    # будем делать restart, когда доработает предыдущий запущенный скрипт start
    # TODO отдельный лок для restart
    print_log("wait_for_file_lock ...");
    do_safely( sub { wait_for_file_lock() },
        timeout => 600,
    ) or die "Could not wait_for_file_lock!";
    print_log("wait_for_file_lock done");
} else {
    get_file_lock()
        or exit(0);

    my $is_running = do_safely(
        sub { check_running_ktserver($ktserver_pid_file) },
        no_die => 1,
    ) ? 1 : 0;
    print_log("is_running: $is_running");
    unless ($is_running) {
        $need_restart = 1;
    }
}

$need_restart //= 0;
print_log("need_restart: $need_restart");
if ($need_restart) {
    restart_ktserver($ktserver_pid_file);
}

exit(0);


sub restart_ktserver {
    my $ktserver_pid_file = shift;
    print_log("restart_ktserver $ktserver_pid_file");

    my $old_pid = get_pid_from_pid_file($ktserver_pid_file);
    print_log("Old pid from pid_file: $old_pid");

    print_log("kill running ktserver ...");
    # Смотрим ps, а не pid_file, т.к. может быть запущенный ktserver, но pid_file пустой
    for my $pid ( get_ktserver_pids_from_ps() ) {
        Utils::Sys::do_sys_cmd("kill $pid");
    }
    Utils::Sys::do_sys_cmd("sleep 10");

    print_log("Check that ktserver is not running ...");
    if (my @pids = get_ktserver_pids_from_ps()) {
        die "Could not kill: pids: @pids";
    }
    # TODO kill -9 if running ?

    print_log("Cleanup pid_file ...");
    Utils::Sys::do_sys_cmd("echo > $ktserver_pid_file");

    print_log("Run ktserver ...");
    #Utils::Sys::do_sys_cmd("ktserver -host 127.0.0.1 -port 11114 -tout 50 -log /opt/broadmatching/log/ktserver.log -dmn -le -pid $ktserver_pid_file -plsv /usr/lib/x86_64-linux-gnu/ktplugservmemc.so -plex port=11115#opts=f /opt/broadmatching/work/kystorage.kch#opts=l#ktcapsiz=1200g#msiz=50g#ktcapcnt=32m");
    Utils::Sys::do_sys_cmd("ktserver -host 127.0.0.1 -port 11114 -tout 50 -log /opt/broadmatching/log/ktserver.log -dmn -ls -pid $ktserver_pid_file -plsv /usr/lib/x86_64-linux-gnu/ktplugservmemc.so -plex port=11115#opts=f /opt/broadmatching/work/kystorage.kch#opts=l#ktcapsiz=1200g#capsiz=1100g#dfunit=16#msiz=50g#ktcapcnt=128m");
    #Utils::Sys::do_sys_cmd("ktserver -host 127.0.0.1 -port 11114 -tout 50 -log /opt/broadmatching/log/ktserver.log -dmn -li -pid $ktserver_pid_file -plsv /usr/lib/x86_64-linux-gnu/ktplugservmemc.so -plex port=11115#opts=f /opt/broadmatching/work/kystorage.kch#opts=l#ktcapsiz=1200g#msiz=50g#ktcapcnt=32m");
        #-li : sets the logging level "INFO".
        #-ls : sets the logging level "SYSTEM".
        #-le : sets the logging level "ERROR".
        #-lz : sets the logging level "NONE".


    print_log("Wait running ktserver ...");
    # Ждем, пока в $ktserver_pid_file появится pid запущенного ktserver
    my $new_pid = do_safely(
        sub { check_running_ktserver($ktserver_pid_file) },
        tries => 30,
        sleep_between_tries => 10,
        verbose => 1,
    ) or die "Could not get new_pid!";

    print_log("Started. new_pid: $new_pid");
}


sub get_ktserver_pids_from_ps {
    my $cmd = "ps ax --format pid,lstart,user,args | grep -P ' bmclient +ktserver ' | grep -v grep";
    print_log("get_ktserver_pids_from_ps cmd: $cmd");
    my @ps = `$cmd`;
    if (@ps) {
        print_log("ps: @ps");
    };
    my @pids = map { m/^\s*(\d+)/ } @ps;
    print_log("get_ktserver_pids_from_ps pids: @pids");
    return @pids;
}

sub get_pid_from_pid_file {
    my $pid_file = shift;

    my $pid = `[[ -f $pid_file ]] && cat $pid_file`;
    chomp $pid;
    print_log("get_pid_from_pid_file: $pid");
    if ($pid =~ m/\d/) {
        return $pid;
    }
    return undef;
}

# Проверяем, запущен ли ktserver
sub check_running_ktserver {
    my ($ktserver_pid_file) = @_;

    my @pids = get_ktserver_pids_from_ps();
    unless (@pids) {
        print_log("ERROR: ktserver is not running");
        return undef; # ktserver не запущен - что-то пошло не так
    }

    my $pid = get_pid_from_pid_file($ktserver_pid_file);
    unless ($pid) {
        die "Void pid in file"; # ktserver запущен, но pid-файл пустой - нужно ждать
    };

    unless (@pids == 1 and $pids[0] == $pid) {
        print_log("ERROR: Bad pids (@pids; $pid)");
        return undef; # что-то пошло не так
    }

    return $pid;
};
