#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;

use BaseProject;

use Utils::Sys qw/md5int/;

my $proj = BaseProject->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my ($phrase, $hits) = split "\t", $line;
    $phrase =~ s/^!//;
    my $phr = $proj->phrase($phrase);
    my $minicategs = join("/", $phr->get_minicategs);
    print join("\t", $phrase, $hits, $minicategs), "\n";
}
