#!/bin/sh -e
#обнаружение дублей фраз в категориях Каталогии

DIR=$(cd $(dirname $0) && pwd) #полный путь данного скрипта
#echo $DIR

CAT_TEMP_DIR=`perl ${DIR}/get_tmp_dir.pl` #имя временной директории
export CAT_TEMP_DIR
#echo $CAT_TEMP_DIR

if [ ! -e $CAT_TEMP_DIR ]
then
  mkdir $CAT_TEMP_DIR
fi
#mkdir -p $CAT_TEMP_DIR

#формат представления фраз
if [ -z $1 ] || ([ $1 != usual ] && [ $1 != norm ] && [ $1 != snorm ])
then
  phr=usual
else
  phr=$1
fi
PHRS_FORMAT=$phr
export PHRS_FORMAT

#тип выдачи
if [ -z $2 ] || ([ $2 != brief ] && [ $2 != full ])
then
  out=brief
else
  out=$2
fi

echo "ОБНАРУЖЕНИЕ ДУБЛЕЙ ФРАЗ В КАТЕГОРИЯХ КАТАЛОГИИ"

D=$(date  +%Y-%m-%d)
T=$(date +%H:%M:%S)
echo  "Начало: $D $T"

echo "Формат представления фраз:" $phr
echo "Тип выдачи:" $out

echo "1. Выбор фраз из Каталогии"
#python ${DIR}/get_ctgs_tree.py
perl ${DIR}/select_phrs.pl >$CAT_TEMP_DIR/phrs_catalogia
LC_ALL=C sort -u $CAT_TEMP_DIR/phrs_catalogia >$CAT_TEMP_DIR/phrs_catalogia.s
perl ${DIR}/delete_dupl.pl <$CAT_TEMP_DIR/phrs_catalogia.s >$CAT_TEMP_DIR/phrs_catalogia
rm $CAT_TEMP_DIR/phrs_catalogia.s

echo "2. Печать фраз из категорий с разверткой атомов"
perl ${DIR}/phr_ctgs_expand1.pl $phr <$CAT_TEMP_DIR/phrs_catalogia >$CAT_TEMP_DIR/phrs_ctgs_dup.dir #---АРГУМЕНТ_1: $phr---
LC_ALL=C sort -u $CAT_TEMP_DIR/phrs_ctgs_dup.dir >$CAT_TEMP_DIR/phrs_ctgs_dup.s
perl ${DIR}/delete_dupl.pl <$CAT_TEMP_DIR/phrs_ctgs_dup.s >$CAT_TEMP_DIR/phrs_ctgs_dup.dir
rm $CAT_TEMP_DIR/phrs_ctgs_dup.s

echo "3. Определение пересечения именованных атомов"
perl ${DIR}/atoms_cross.pl >$CAT_TEMP_DIR/atoms_cross.s
LC_ALL=C sort -u $CAT_TEMP_DIR/atoms_cross.s >$CAT_TEMP_DIR/atoms_cross
rm $CAT_TEMP_DIR/atoms_cross.s

echo "4. Вычисление лексических сигнатур для фраз"
perl ${DIR}/words_in_atom.pl <$CAT_TEMP_DIR/phrs_ctgs_dup.dir >$CAT_TEMP_DIR/phrs_ctgs_dup.dir2.s #построение лексической сигнатуры
LC_ALL=C sort -u $CAT_TEMP_DIR/phrs_ctgs_dup.dir2.s >$CAT_TEMP_DIR/phrs_ctgs_dup.dir2
rm $CAT_TEMP_DIR/phrs_ctgs_dup.dir2.s

echo "5. Развертка фраз с атомами (без учета порядка слов)"
perl ${DIR}/select4expand.pl $out <$CAT_TEMP_DIR/phrs_ctgs_dup.dir2 >$CAT_TEMP_DIR/dupl_expanded.s #---АРГУМЕНТ_2: $out---
LC_ALL=C sort -u $CAT_TEMP_DIR/dupl_expanded.s >$CAT_TEMP_DIR/dupl_expanded
rm $CAT_TEMP_DIR/dupl_expanded.s

echo "6. Распознавание дублей (без учета порядка слов)"
perl ${DIR}/unorder_dupl.pl <$CAT_TEMP_DIR/phrs_ctgs_dup.dir >$CAT_TEMP_DIR/unorder_dupl.s
LC_ALL=C sort -u $CAT_TEMP_DIR/unorder_dupl.s >$CAT_TEMP_DIR/unorder_dupl
rm $CAT_TEMP_DIR/unorder_dupl.s

echo "7. Объединение источников дублей"
LC_ALL=C sort -u $CAT_TEMP_DIR/dupl_expanded $CAT_TEMP_DIR/unorder_dupl >$CAT_TEMP_DIR/phrs_ctgs_dup
rm $CAT_TEMP_DIR/dupl_expanded $CAT_TEMP_DIR/unorder_dupl

echo "8. Печать найденных дублей"
perl ${DIR}/sel_dupl.pl <$CAT_TEMP_DIR/phrs_ctgs_dup >$CAT_TEMP_DIR/ctgs_dupl_${phr}_${D}_${T} #не сортировать, т.к. записи упорядочены по специальному ключу для нахождения неупорядоченных дублей
rm $CAT_TEMP_DIR/phrs_ctgs_dup

#echo "Number_of_Duplicates:" $[`wc $CAT_TEMP_DIR/ctgs_dupl |awk '{print $1}'` / 2]
echo $[`wc $CAT_TEMP_DIR/ctgs_dupl_${phr}_${D}_${T} |awk '{print $1}'` / 2] >$CAT_TEMP_DIR/num_of_dupl_${phr}_${D}_${T}

rm $CAT_TEMP_DIR/atoms_cross
#rm $CAT_TEMP_DIR/ctgs_full_list
rm $CAT_TEMP_DIR/named_atoms
rm $CAT_TEMP_DIR/phrs_catalogia
rm $CAT_TEMP_DIR/phrs_ctgs_dup.dir
rm $CAT_TEMP_DIR/phrs_ctgs_dup.dir2

#rm $CAT_TEMP_DIR/ctgs_dupl

D=$(date  +%Y-%m-%d)
T=$(date +%H:%M:%S)
echo  "Завершение: $D $T"
