#!/usr/bin/perl -w
#печать дублей из разных категорий

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;
use Utils::Sys qw(print_log print_err get_file_lock release_file_lock handle_errors);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
    memlog => 1,
});

handle_errors;
get_file_lock() or do {
    print_err("WARN: found already running script, do exit");
    exit(0);
};

#--- блок записей для анализа ---
my @key; #<ключ> (см. select4expand.pl и unorder_dupl.pl)
my @phr; #<фраза>
my @id; #<ID категории>
my @num; #<номер фразы в категории>
my @phr_src; #<фраза в исходной форме>

my $rec_count = 0; #####
while (my $rec = <STDIN>) { #phrs_ctgs_dup
    #$rec_count++; #####
    #print STDERR "$rec_count\n" if $rec_count % 10000 == 0; #####

    chomp $rec;
    my ($key, $phr, $id, $num, $phr_src) = split /\t/, $rec; #<ключ>, <фраза>, <ID категории>, <номер фразы в категории>, <фраза в исходной форме>

    my $ret = add_to_block($key, $phr, $id, $num, $phr_src); #добавление записи к блоку
    block_proc($key, $phr, $id, $num, $phr_src) unless $ret; #обработка блока
}
block_proc("", "", "", "", "");

my $PHRS_FORMAT = $ENV{PHRS_FORMAT}; #в родительском скрипте dup_detect.sh
$rec_count = $rec_count / 2;
print_err("NUM_OF_DUPL_$PHRS_FORMAT: $rec_count");
print_err("dupl_detect_${PHRS_FORMAT}_OK");


#--- добавление записей к блоку ---
sub add_to_block {
    my ($key, $phr, $id, $num, $phr_src) = @_;

    if (@key == 0 || $key[0] eq $key) {
        push @key, $key;
        push @phr, $phr;
        push @id, $id;
        push @num, $num;
        push @phr_src, $phr_src;
        return 1;
    }
    return 0;
}


#--- обработка блока ---
sub block_proc {
    my ($key, $phr, $id, $num, $phr_src) = @_;

    if (@key > 1) {
        my %id;
        for my $i (0..$#key) { #проверка разнообразия категорий
            $id{$id[$i]} = 1;
        }

        if (keys %id > 1) { #в блоке категорий > 1
            %id = ();
            for my $i (0..$#key) {
                unless ($id{$id[$i]}) { #выводим каждую категорию по 1 разу
                    my $ctg = $proj->categs_tree->get_minicateg_by_id($id[$i]);
                    print "$phr[$i]\t$ctg\t$id[$i]\t$num[$i]\t$phr_src[$i]\n";
                    $rec_count++;
                    $id{$id[$i]} = 1;
                }
            }
        }
    }

    #новый блок
    @key = ($key);
    @phr = ($phr);
    @id = ($id);
    @num = ($num);
    @phr_src = ($phr_src);
}
