#!/usr/bin/perl -w
#выбор фраз из Каталогии для поиска дублей (чтобы иметь фиксированную базу на момент обработки)

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;
use Utils::Sys qw(print_log print_err get_file_lock release_file_lock handle_errors);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
    memlog => 1,
});

my $CAT_TEMP_DIR = $ENV{CAT_TEMP_DIR}; #в родительском скрипте dup_detect.sh

#`curl https://catmedia.yandex.ru/acgi-bin/interface/get_categs_tree.pl >$CAT_TEMP_DIR/ctgs_full_list`; #выдает все категории

handle_errors;
get_file_lock() or do {
    print_err("WARN: found already running script, do exit");
    exit(0);
};

my @ctgs = $proj->categs_tree->get_minicategs_list;
for my $ctg (@ctgs) {
    next if $ctg =~ /^\./; #именованные атомы пропускаем
    #next unless $ctg =~ /^(Андрология|Урология)$/; #####

    my $ctg_id = $proj->categs_tree->get_minicateg_id($ctg);

    my @ctg_phrs = $proj->default_language->get_category_raw_phrases($ctg);
    @ctg_phrs = sort {lc($a) cmp lc($b)} @ctg_phrs; #сортировка без учета регистра

    if (@ctg_phrs) {
        my $phr_num = 0; #порядковый номер фразы внутри категории
        for my $ctg_phr (@ctg_phrs) {
            $phr_num++;
            print "$ctg_phr\t$ctg_id\t$phr_num\n";
        }
    }
}

print_err("select_phrs.pl_OK");
