#!/usr/bin/perl -w
#добавление неупорядоченности к обычным фразам

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Utils::Sys qw(print_log print_err get_file_lock release_file_lock handle_errors);

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

handle_errors;
get_file_lock() or do {
    print_err("WARN: found already running script, do exit");
    exit(0);
};

while (<STDIN>) { #phrs_ctgs_dup.dir
    chomp;
    my ($phr, $id, $num) = split /\t/; #фраза, ID категории, номер фразы в категории
    next if $phr =~ /\[/;

    $phr =~ s/^ +//;
    $phr =~ s/ +$//;
    $phr =~ s/  +/ /g;

    my @wds = phr_parse($phr);
    my @key = map { lc($_) } @wds;
    my $key = join(" ", sort @key); # *** добавляем неупорядоченность

    print "$key\t$_\n"
}

print_err("unorder_dupl.pl_OK");


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
