#!/usr/bin/perl -w
use strict;

use utf8;
use open ":utf8";

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';

use File::Temp qw(tempdir);

use FindBin;
use lib "$FindBin::Bin/lib";
use lib "$FindBin::Bin/wlib";
use CatalogiaMediaProject;
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    handle_errors
    print_err
);
use Utils::Common;
use Data::Dumper;
use JSON::XS;

handle_errors();
#handle_errors(WARN => {stack_trace => 1}, DIE => {stack_trace => 1}, );

my ($fn_data, $fn_out, $data_type, $diff_type, $lang, $fn_caddphr) = @ARGV;
die("bad input") if !$fn_data || !$fn_out || !$data_type || !$lang || !$data_type;

my $proj = CatalogiaMediaProject->new( prepare_proj_opts() );
$proj->categs_tree->never_write_categs_cache(1);
$proj->categs_tree->never_read_categs_cache(1);
init_proj();

my $json = JSON::XS->new->pretty(0);
open F, $fn_data or die($!);
open G, "> $fn_out" or die($!);
while(<F>) {
    my $phr;
    my $id;

    if($data_type eq "banner") {
        my $bnr = $proj->banner_factory->text2banner($_);
        $phr = $bnr->preprocess_title_body;
        $id = $bnr->id;
    } elsif($data_type eq "query") {
        $phr = $proj->get_language($lang)->phrase($_);
        $id = $.;
    } else {
        die("unknown data type '$data_type'");
    }

    my $json_field = $json->encode({
        bid         => $id,
        categs      => [ $phr->get_minicategs ],
        orig        => $phr->orig_minicategs_subphrases_hash,
        decoded     => $phr->decode_minicategs_subphrases_hash,
        categs_phrases_hlist => $phr->get_categs_phrases_hlist,
    });

    print G "$json_field\n";
    $proj->log("$. done") unless $. % 1000;
}
close F;
close G;
exit(0);

sub prepare_proj_opts {

    my $no_light = (
            $diff_type eq 'transform'
        or  $diff_type eq 'chng_dict'
        or  $diff_type eq 'custom'
    ) ? 1 : 0;
    my $use_comptrie_subphraser = ($diff_type eq 'chng_dict_cmptr') ? 1 : 0;   # chng_dict_cmptr - для тестирования comptrie-subphraser

    my $opts = {
        load_dicts      => 1,
        load_languages  => [$lang],
        load_minicategs_light   => ! $no_light,
        load_minicategs         => $no_light,
        use_comptrie_subphraser => $use_comptrie_subphraser,
        projsrv         => 0,
        nrmsrv          => 0,
        no_auth         => 1,
        no_form         => 1,
        memlog          => 1,
    };

    if($fn_caddphr) {
        if(     $diff_type eq "phrases"
            or  $diff_type eq "actions"
            or  $diff_type eq "actions_custom"
            or  $diff_type eq "beta_t"
        ) {

        } elsif($diff_type eq "transform") {
            my @lines;
            open F, $fn_caddphr or die($!);
            @lines = <F>;
            close F;

            my $source = join("", @lines);
            $opts->{categ_phrase_transform} = sub {
                my ($categ, $phrase) = @_;
                my $result = eval $source;

                if($@) {
                    die(sprintf("phrase: '%s', categ: '%s', error: '%s'", $phrase->text, $categ, $@));
                }

                return $result;
            };
        } elsif($diff_type eq "prefilter") {
            my @lines;
            open F, $fn_caddphr or die($!);
            @lines = <F>;
            close F;

            my $source = join("", @lines);
            $opts->{test_banner_categ_prefilter} = sub {
                my ($proj, $text) = @_;
                my $result = eval $source;

                if($@) {
                    #die(sprintf("phrase: '%s', categ: '%s', error: '%s'", $phrase->text, $categ, $phrase));
                    die("banner text: '$text'");
                }

                return $result;
            };
        } elsif(   $diff_type eq 'chng_dict'
                or $diff_type eq 'chng_dict_light'
                or $diff_type eq 'chng_dict_cmptr'
        ) { 
            my $dict_name = "$fn_caddphr.dict";

            open F, $fn_caddphr or die($!);
            open G, ">$dict_name" or die($!);

            # до первой пустой строки -- код, который нужно выполнить
            my @perl_lines;
            while(<F>) {
                if(/^\s*$/) {
                    last;
                } else {
                    push @perl_lines, $_;
                }
            }

            # текст доп. словаря
            while(<F>) {
                print G;
            }

            close G;
            close F;

            my $perl_lines = join("", @perl_lines);
            print_err("perl_lines: $perl_lines");
            # выполнение кода
            eval $perl_lines;

            if($@) {
                die($!);
            }
        } elsif(    $diff_type eq 'custom'
                 or $diff_type eq 'custom_light'
        ) { 
            #my $input_dir = tempdir("categs_diff_helper.temp.XXXX", DIR => $Utils::Common::options->{dirs}{temp}, CLEANUP => 1);
            my $input_dir = tempdir("categs_diff_helper.temp.XXXX", DIR => $Utils::Common::options->{dirs}{temp}, );
            Utils::Sys::do_sys_cmd("chmod a+rx $input_dir"); # Для удобства отладки меняем права, т.к. директория была создана с правами drwx------
            # Archive creating example:   tar -cvf tmp.tar *
            Utils::Sys::do_sys_cmd("cd $input_dir && tar -xvf $fn_caddphr && cd ", no_die => 1); # no_die - kostyl! TODO 
            my $file_code = "$input_dir/code"; # код, который нужно выполнить
            open F, $file_code or die($!);
            my @perl_lines;
            while(<F>) {
                if(/^\s*$/) {
                    last;
                } else {
                    push @perl_lines, $_;
                }
            }
            close F or die($!);
            my $perl_lines = join("", @perl_lines);
            print_err("perl_lines: $perl_lines");
            # выполнение кода
            eval $perl_lines;
            if($@) {
                die("$@ ($!)");
            }
        } else {
            die("unknown diff type '$diff_type'");
        }
    }

    return $opts;
}

sub init_proj {
    if($diff_type eq "phrases") {
        $proj->subphrases_client->create_private_server;
        
        if($fn_caddphr) {
            my $language = $proj->get_language($lang);

            open F, $fn_caddphr or die($!);
            while(<F>) {
                chomp;
                my ($categ, $phrases) = split "\t";
                next if !$categ || !$phrases;

                if(!$proj->categs_tree->get_minicateg_id($categ)) {
                    $proj->log("ERROR: unknown category '$categ'");
                    next;
                }

                $language->phrase($_)->add_subphraser_category($categ) for grep{!/^\s*$/} split ",", $phrases;
            }
            close F;
        }
    } elsif($diff_type eq "actions"  or $diff_type eq "actions_custom") {
        $proj->subphrases_client->create_private_server;
        
        if($fn_caddphr) {
            open F, $fn_caddphr or die($!);
            my $data = join "", <F>;
            close F;
            my $actions;
            eval { 
                $actions = $proj->deserial( $data )->[0]; 
            };
            if($@) {
                die("data parsing failed: $@");
            }

            # вносим изменения
            my $good_action_count = 0;
            for my $action_obj (@$actions) {
                my ($action, $cat_id, $text, $lang) = map{$action_obj->{$_}} qw(Action CatID InitialPhrase Language);
                $proj->log("Should add: $action, $cat_id, $lang, $text");

                my @supported_actions = qw/Add Delete AddFlag AddAntiword AddPrefilter/;
                if(grep {$action eq $_} @supported_actions) {
                    my $phrase = $proj->get_language($lang)->phrase($text);
                    my $categ = $proj->categs_tree->get_minicateg_by_id($cat_id);

                    if(!$categ && $action ne 'AddPrefilter') {
                        $proj->log("ERROR: unknown category $cat_id");
                        next;
                    }

                    if($action eq "Add") {
                        $phrase->add_subphraser_category($categ);
                    } elsif($action eq "Delete") {
                        $phrase->delete_subphraser_category($categ);
                    } elsif($action eq "AddFlag") {
                        $proj->categs_tree->set_minicateg_flag($categ, $text);
                    } elsif($action eq "AddAntiword") {
                        $phrase->add_to_categ_antiwords($categ);
                    } elsif($action eq 'AddPrefilter') {
                        my ($pattern, $replace) = split /\t/, $text;
                        $proj->get_language('ru')->prefilter->push_prefilter($pattern, $replace);
                    }
                } else {
                    $proj->log("ERROR: unknown action '$action'");
                    next;
                }

                $good_action_count++;
            }

            if(!$good_action_count) {
                die("no good actions");
            } else {
                $proj->log("$good_action_count good actions");
            }
        }
    }
}

