#!/usr/bin/perl
use strict;

use utf8;
use open ":utf8";

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../wlib";
use Utils::Common;
use Utils::Sys qw/
    get_file_lock
    release_file_lock
    handle_errors
    dir_files
    modtime
    print_err
/;
use CatalogiaMediaProject;
use BM::Phrase;
use Data::Dumper;
use Cmds::Moderation;

get_file_lock("check-moderation") or print_err("found already running script, do exit") and exit(0);

handle_errors;

my $proj = CatalogiaMediaProject->new({ 
    load_dicts              => 1,
    load_minicategs_light   => 1,
    load_languages          => ["en", "tr"],
    no_auth                 => 1, 
    no_form                 => 1 
});

$proj->categs_tree->never_write_categs_cache(1);
$proj->categs_tree->never_read_categs_cache(1);

my $phrases = $proj->user_phrases->List([ 
    [ Status => "New" ],
]);

my $check_moderation_new_table = $proj->check_moderation->db_table . 'New';
my $check_moderation_done_table = $proj->check_moderation->db_table . 'Done';

dbh_do("drop table if exists $check_moderation_new_table");
create_table($proj->check_moderation->db_table);
create_table($check_moderation_new_table);

my $phrase2categs = {};
for my $item(@$phrases) {
    if($item->{Action} eq "Add") {
       ($phrase2categs->{$item->{InitialPhrase}."\t".$item->{Language}} ||= {})->{$item->{CatID}}++;
    }
}

for my $item (@$phrases) {
    my ($cat_id, $lang, $initial_phrase_id, $action) = @{$item}{qw(CatID Language InitialPhraseID Action)};

    if ($action eq "Add") {
        # для действия 'Add' используем новый глазик
        $proj->Do_SQL("
            insert into
                " . $check_moderation_new_table . " (CatID, Language, InitialPhraseID, Action, TrackingUpdatesPhrasesCount)
            values
                (?, ?, ?, ?, ?)
        ", [$cat_id, $lang, $initial_phrase_id, $action,
            scalar(@{$proj->get_tracking_updates_phrases($cat_id, $lang, $initial_phrase_id, $action, 'new')})]);
    } elsif ($action eq "Delete") {
        # фраза была окончательно удалена
        # push @tags, "deleted" if !$phrase2categs->{$item->{InitialPhrase}."\t".$item->{Language}};
        $proj->Do_SQL("
            insert into
                " . $check_moderation_new_table . " (CatID, Language, InitialPhraseID, Action, TrackingUpdatesPhrasesCount)
            values
                (?, ?, ?, ?, ?)
        ", [$cat_id, $lang, $initial_phrase_id, $action,
            scalar(@{$proj->get_tracking_updates_phrases($cat_id, $lang, $initial_phrase_id, $action)})]);
    }
}

dbh_do("drop table if exists $check_moderation_done_table");
dbh_do("rename table " . $proj->check_moderation->db_table." to $check_moderation_done_table, ".
       "$check_moderation_new_table to " . $proj->check_moderation->db_table);

$proj->log("done");

release_file_lock("check-moderation"); 

exit(0);

sub dbh_do {
    my ($cmd) = @_;

    $proj->dbh->do($cmd) or die("ERROR: query = '$cmd', errstr = '$DBI::errstr'")
}

sub create_table {
	my ($table ) = @_;
	dbh_do("CREATE TABLE if not exists `$table` (
          `CatID`   char(20) NOT NULL DEFAULT '',
          `Language`   char(2) NOT NULL DEFAULT 'ru',
          `InitialPhraseID` bigint(20) unsigned default '0',
          `Action` char(20) NOT NULL DEFAULT 'Add',
          `Tags` text not null,
          `TrackingUpdatesPhrasesCount` int unsigned NOT NULL DEFAULT '0',
          primary key (CatID, InitialPhraseID, Language, Action),
          key(InitialPhraseID)
	  ) ENGINE=MyISAM DEFAULT CHARSET=utf8
	  ");
}
