#!/usr/bin/perl -w
#use strict;
use utf8;
use open ":utf8";
no warnings "utf8";
binmode (STDIN, ":utf8");
binmode (STDOUT, ":utf8");
binmode (STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../wlib";
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    print_log
    handle_errors
);
use CatalogiaMediaProject;
use Data::Dumper;
use Utils::XLS;
use Cmds::BroadMatch;
use List::Util qw[ min max maxstr minstr ];

get_file_lock() or exit(0);
handle_errors();
print_log("update-csyns-table.pl started");

my $proj = CatalogiaMediaProject->new({ indcmd => 1, 
    no_auth => 1,
    no_form => 1,
    nrmsrv => 0,   # Если nrmsrv не задан, то в него записывается 1 (в init в CatalogiaMediaProject) 
    projsrv => 0,
});

update_csyns_table($proj);

print_log("update-csyns-table.pl finished");
release_file_lock();

exit(0);


# Обновить таблицу ContextSynFresh: записать в нее контекстные синонимы из таблицы CatalogiaPhrases
sub update_csyns_table {
    my ($proj) = @_;

    $proj->log("Get CatalogiaPhrases(AddContextSyn) update time");
    my $update_time_new = $proj->List_SQL(
        "select max(UpdateTime) max_UpdateTime from CatalogiaPhrases where Action = 'AddContextSyn'"
    )->[0]->{'max_UpdateTime'};

    my $table_csyns = 'ContextSynFresh';
    $proj->log("Get $table_csyns phrases update time");
    my $update_time_current = '';
    my $tbl_info = $proj->List_SQL("show table status like '$table_csyns'") // [];   # TODO
    my $table_csyns_exists = 0;
    if (@$tbl_info) {
        $update_time_current = $proj->List_SQL("select max(UpdateTime) max_UpdateTime from $table_csyns")->[0]->{'max_UpdateTime'};
        $table_csyns_exists = 1;
    }

    #$update_time_current = "";      $proj->log("TEST: update always");      # TODO remove

    $proj->log("Check update_time");
    if ($update_time_new le $update_time_current) {
        $proj->log("Do not need to update $table_csyns ('$update_time_current', '$update_time_new')");
        return 1;
    }

    $proj->log("Need update ('$update_time_current', '$update_time_new')");

    $proj->log("Temporary table");
    my $table_tmp = "TMP_$table_csyns";
    my $table_def = $BM::DB::Tables::table_def{$table_csyns};
    $proj->Do_SQL("drop table if exists $table_tmp");
    $proj->Do_SQL("create table $table_tmp " . $table_def) or do {
        die "Could not create table $table_tmp, $DBI::errstr";
    };

    $proj->log("Insert");
    my $stm = join(" ",
        "insert into $table_tmp (Language, InitialPhrase, Status, UpdateTime)",
        "(select Language, InitialPhrase, Status, UpdateTime from CatalogiaPhrases",
        "   where Action = 'AddContextSyn'",
        ")",
    );
    $proj->log("stm: $stm");

    $proj->Do_SQL($stm);

    $proj->log("Rename tables");
    my $table_done = "Done$table_csyns";
    $proj->Do_SQL("drop table if exists $table_done");
    if ($table_csyns_exists) {
        $proj->Do_SQL("rename table $table_csyns to $table_done, $table_tmp to $table_csyns") or do {
            die "Could not rename $table_csyns to $table_done, $table_tmp to $table_csyns, $DBI::errstr";
        };
    } else {
        $proj->Do_SQL("rename table $table_tmp to $table_csyns") or do {
            die "Could not rename $table_csyns to $table_done, $DBI::errstr";
        };
    }

    $proj->log("Table ($table_csyns) updated");
}



