#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

handle_errors;

if(!$ARGV[0]) {
    die("usage: start.pl name");
}

get_file_lock("cdict-start-server-$ARGV[0]") or print_err("found already running script, do exit") and exit(0);

my $proj = Project->new({});
my $client = $proj->{$ARGV[0]};

if(!$client) {
    die("bad name '$ARGV[0]'");
}

# команда для запуска
my @cmd = (
    "LD_PRELOAD=\"/usr/lib/libtcmalloc_minimal.so.4\"",
    $client->server_dir."/cdict", 
    "--norm-config=".$client->norm_config_file,
    "--port=".$client->port,
    "--logging-level=Full", # максимальный уровень логгирования
);

# выбор входных данных
if($client->single_file && -e $client->single_file) {
    push @cmd, "--single-file=" . $client->single_file;
} elsif($client->index_file && -e $client->index_file) {
    push @cmd, "--data-file=".$client->index_file;
    push @cmd, "--dict-file=".$client->dict_file;
} else {
    $proj->log("no data file");
    exit(2);
}

# запуск сервера
$proj->do_sys_cmd(join(" ", @cmd));

release_file_lock("cdict-start-server-$ARGV[0]") or print_err("found already running script, do exit") and exit(0);

