#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

get_file_lock("cdict-start-server") or print_err("found already running script, do exit") and exit(0);

handle_errors;

my $proj = Project->new({});

# если файла с данными нет, выходим
unless(-e $proj->cdict_client->index_file) {
    $proj->log("no data file, do exit");
    exit(0);
}

# запуск сервера
$proj->do_sys_cmd(join " ",
    $proj->cdict_client->server_dir."/cdict", 
    "--norm-config=".$proj->cdict_client->norm_config_file,
    "--port=".$proj->cdict_client->port,
    "--data-file=".$proj->cdict_client->index_file,
    "--dict-file=".$proj->cdict_client->dict_file
);

release_file_lock("cdict-start-server") or print_err("found already running script, do exit") and exit(0);

