#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

handle_errors;

if(!$ARGV[0]) {
    die("usage: start.pl name");
}

get_file_lock("cdict-stop-server-$ARGV[0]") or print_err("found already running script, do exit") and exit(0);

my $proj = Project->new({});
my $client = $proj->{$ARGV[0]};

if(!$client) {
    die("bad name '$ARGV[0]'");
}

# остановка сервера
$proj->log("stop server");
$client->{host} = "127.0.0.1";
$client->stop_server;
$proj->log("/ stop server");

release_file_lock("cdict-stop-server-$ARGV[0]") or print_err("found already running script, do exit") and exit(0);

