#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

get_file_lock("cdict-stop-server") or print_err("found already running script, do exit") and exit(0);

handle_errors;

my $proj = Project->new({});

# остановка сервера
$proj->log("stop server");
$proj->cdict_client->stop_server;
$proj->log("/ stop server");

release_file_lock("cdict-stop-server") or print_err("found already running script, do exit") and exit(0);

