#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use File::Find;

use FindBin;
use lib "$FindBin::Bin/lib";

use Getopt::Long;

use Utils::Common;
use Utils::Sys;

my %opt = (
    dir => $Utils::Common::options->{dirs}{temp},
    max_days => 30,
    #verbose => 0,
);
GetOptions(\%opt, 'dir=s', 'max_days=i', 'regexp=s', 'verbose', 'help|h');
if ($opt{help}) {
    printf "Options:\n";
    printf "  --dir=s\n";
    printf "  --max_days=i\n";
    #printf "  --verbose\n";
    exit(0);
}

my $lock_name = "cleanup-tempdir_" . $opt{dir}; #TODO
$lock_name =~ s/[^a-z0-9\-_]/_/ig;
get_file_lock($lock_name) or exit(0);
#print_log("lock_name: $lock_name");
handle_errors();

my $temp_dir = $opt{dir};
my $max_days = $opt{max_days};
my $regexp = $opt{regexp};

my $find_handler = sub {
    #print_log(`ls -ld $_`);

    # игнорим .svn
    return if $File::Find::dir =~ /\/\.svn(\/|$)/;

    my $name = $File::Find::name;

    if (-d $name) {
        # TODO: удалять пустые директории, причем надо не удалить случайно такие, которые
        # только что создали и они еще пустые

        # opendir my($dh), $name or next;
        # if (scalar(grep { $_ ne "." && $_ ne ".." } readdir $dh) == 0) {
        #     print_log("remove dir $name");
        #     Utils::Sys::do_sys_cmd("rm $name -r");
        # }
        # closedir $dh;
    }

    return if !-f $name;

    # удаляем только заданное регуляркой
    if ( $regexp ){
        return unless $name =~ /$regexp/;
    }

    # удаляем только файлы старше $max_days
    return if (time - mtime($name)) < $max_days * 3600 * 24;

    # на всякий случай
    if ($name =~ /\.(pl|pm|sh|cpp)$/) {
        print_log("ERROR: '$name': script file in temp");
        return;
    }

    print_log("deleting file '$name'");
    if (system('rm', $name) != 0) {
        print_log("ERROR: can't delete '$name': $!");
    }
};

#bydepth:    Reports the name of a directory only AFTER all its entries have been reported
#TODO: use no_chdir ?   https://a.yandex-team.ru/commit/2665496
File::Find::find({ wanted => $find_handler, follow => 0, bydepth => 1}, $temp_dir); # важно не пойти по симлинкам!

