#pragma once

#include <vector>

using DataItem = uint64_t;  // "полный" banner_id
typedef uint32_t bid_size;  // "номер" баннера в векторе bids, и производные величины

class Index {
public:

    Index() {}
    ~Index() {}

    // новые функции для компактного бендера
    bool            LoadText(const char *encoded_file, const char *index_file);
    bool            LoadEncoded(const char *encoded_file, bool is_reserving);
    bool            LoadIndex(const char *index_file, bool is_reserving);
    bool            LoadBinary(const char *file_name);
    bool            SaveBinary(const char *file_name) const;
    void            Dump() const;
    size_t          FindWord(const char *word) const;
    const bid_size* GetWordIndex(bid_size word_i) const;
    const bid_size* GetWordIndexEnd(bid_size word_i) const;
    bid_size        GetBannerCount(bid_size word_i) const;

    // поиск баннеров по запросу
    void Search(
        const char* phrase,            // фраза
        unsigned max_top,              // максимальный размер топа (0 -- без ограничений)
        std::vector<DataItem>& result    // выходной массив
    ) const;

    // поиск случайных баннеров
    void RandomBanners(
        unsigned sample_size,          // размер выборки (попросить без ограничений нельзя)
        std::vector<DataItem>& result  // выходной массив
    ) const;

    // поиск случайных баннеров по запросу
    void RandomBannersQuery(
        const char* phrase,            // запрос
        unsigned sample_size,          // размер выборки (попросить без ограничений нельзя)
        std::vector<DataItem>& result  // выходной массив
    ) const;


private:

    // В каждом шарде хранится меньше 2^32 баннеров. Поэтому в большом индексе (words_data),
    // где каждый баннер повторяется много раз, хранятся только номера баннеров (uint32),
    // а в bids, хранится маппинг из номера в bid (который может быть больше 2^32 и поэтому uint64)
    std::vector<DataItem> bids;

    // Сырой массив байтов со следующим форматом:
    // слово в кодировке utf-8 (с нулевым байтом в конце);
    // отсортированные номера баннеров, где это слово содержится (именно номера, а не bid-ы)
    // число 0 (uint32 как и номера баннеров) как признак того, что баннеры для этого слова закончились
    // Далее идет новое слово и.т.д
    //
    // Слова отсортированы, в самом начале массива есть пустое слово без баннеров (только с uint32 0).
    //
    // Например, есть есть только три баннера со словом cat, то words_data =
    // 00 00 00 00 00 63 61 74 00 00 00 00 01 00 00 00 02 00 00 00 03 00 00 00 00
    std::vector<char> words_data;

    // Позиции начал слов в массиве words_data
    std::vector<char*> words_index;
};
