#include "Pattern.h"

#include <util/string/join.h>

Pattern::Pattern(const char* str) {
    bool group_started = false;
    const char *start = str, *end;

    num_groups = 0;
    while(*start) {
        if(*start == '|') {
            phrase2group.push_back(num_groups - 1);
            start++;
        } else if(*start == ')' || *start == '(' || *start == '?') {
            if(*start == '?') {
                is_group_optional[num_groups - 1] = true;
            }
            group_started = false;
            start++;
        } else {
            if(!group_started) {
                group_started = true;
                num_groups++;
                phrase2group.push_back(num_groups - 1);
                is_group_optional.push_back(false);
            }
            for(end = start; *end && *end != ' ' && *end != '|' && *end != '(' && *end != ')' && *end != '?'; end++);

            std::string word(start, end);
            words.push_back(word);
            word2phrase.push_back(phrase2group.size() - 1);
            start = end;
        }

        for(;*start && *start == ' '; start++);
    }

    needed_groups = 0;
    for (unsigned i = 0; i < num_groups; i++) {
        if(!is_group_optional[i]) {
            needed_groups |= (1 << i);
        }
    }
}

std::string Pattern::Match(const std::vector<bool>& mask) const {
    if(phrase2group.size() == 1 && num_groups == 1) {
        for(unsigned i = 0; i < mask.size(); i++) {
            if(!mask[i]) {
                return "";
            }
        }

        return JoinSeq(" ", words);
    }

    return MatchFull(mask);
}

std::string Pattern::MatchFull(const std::vector<bool>& mask) const {
    unsigned used_groups = 0, i;

    std::vector<bool> used_phrases(phrase2group.size(), true);

    // проверка слов во фразах
    for(unsigned i = 0; i < NumWords(); i++) {
        if(!mask[i]) {
            unsigned ph = word2phrase[i];
            used_phrases[ph] = false;
        }
    }

    // проверка фраз в группах
    std::vector<bool> is_phrase_used(phrase2group.size());
    for(i = 0; i < phrase2group.size(); i++) {
        if(used_phrases[i]) {
            unsigned x = (1 << phrase2group[i]);

            if(!(used_groups & x)) {
                is_phrase_used[i] = true;
                used_groups |= x;
            }
        }
    }

    if((used_groups & needed_groups) == needed_groups) {
        std::vector<std::string> words;

        for(i = 0; i < NumWords(); i++) {
            if(is_phrase_used[word2phrase[i]]) {
                words.push_back(Word(i));
            }
        }

        return JoinSeq(" ", words);
    }

    return "";
}
