#pragma once

#include <string>
#include <vector>

class Pattern {
public:

    Pattern(const char* str);
    ~Pattern() {}

    unsigned        NumWords() const                { return words.size(); }
    unsigned        NumGroups() const               { return num_groups; }
    const char*     Word(unsigned i) const          { return words[i].c_str(); }
    unsigned        WordToPhrase(unsigned i) const  { return word2phrase[i]; }
    unsigned        WordToGroup(unsigned i) const   { return phrase2group[word2phrase[i]]; }

    // для запроса "мама (мыла раму|ела кашу)":
    // words => ["мама", "мыла", "раму", "ела", "кашу"], "мыла" - слово
    // word2phrase => [0, 1, 1, 2, 2], "мыла раму" - фраза
    // phrase2group => [0, 1, 1], "(мыла раму|ела кашу)" - группа

    // проверить, подходит ли набор слов под шаблон
    std::string     Match(const std::vector<bool>& mask) const;

    // паттерн, состоящий из одной фразы
    bool            IsSimple() const        { return phrase2group.size() == 1 && num_groups == 1; }

    // обязательная ли группа
    bool            IsGroupOptional(unsigned i) const    { return is_group_optional[i]; }

private:

    std::string    MatchFull(const std::vector<bool>& mask) const;

private:

    std::vector<unsigned>       word2phrase;
    std::vector<unsigned>       phrase2group;
    std::vector<bool>           is_group_optional;
    unsigned                    needed_groups;
    unsigned                    num_groups;
    std::vector<std::string>    words;
};
