#include <rt-research/broadmatching/scripts/cpp-source/bender/BenderServer.h>
#include <rt-research/broadmatching/scripts/cpp-source/bender/Index.h>

#include <irt/common/lib/logger/logger.h>

#include <util/generic/string.h>
#include <library/cpp/getopt/small/last_getopt.h>
#include <library/cpp/logger/global/global.h>

int main(int argc, char** argv) {
    NIRT::InitLog<NIRT::TTabLoggerFormatter>({.ConsoleOnly=true});

    uint32_t port;
    TString encoded_file;
    TString index_file;
    TString binary_file;

    NLastGetopt::TOpts opts;
    opts.AddLongOption("port").Optional().DefaultValue("0").StoreResult(&port);
    opts.AddLongOption("encoded-file").Optional().StoreResult(&encoded_file);
    opts.AddLongOption("index-file").Optional().StoreResult(&index_file);
    opts.AddLongOption("binary-file").Optional().StoreResult(&binary_file);

    NLastGetopt::TOptsParseResult (&opts, argc, argv);

    Index index;

    if(index_file) {
        if(!index.LoadText(encoded_file.data(), index_file.data())) {
            INFO_LOG << "can't load data";
            return 1;
        }

        index.Dump();

        if(binary_file) {
            INFO_LOG << "saving to " << binary_file << ": " << index.SaveBinary(binary_file.data());
        }

        return 0;
    }

    if(! binary_file) {
        return 1;
    }

    if(index.LoadBinary(binary_file.data())) {
        INFO_LOG << "loaded data version 1";
        index.Dump();
        BenderServer server(index, port);
        server.Run();
    } else {
        INFO_LOG << "can't load binary data";
        return 1;
    }

    return 0;
}
