#pragma once

#include <util/string/builder.h>

#include <string>
#include <vector>

class Index;
class MultiIndex;

const int BM_CHECK_BAD_WORDS = 1;
const int BM_FULL = 2;

class BroadMatcher {
public:

    BroadMatcher();
    void Match(const MultiIndex& index, const char *dict, size_t max_phrases, int flags, const std::vector<std::string>& words, const std::vector<unsigned>& counts, TStringBuilder& buffer) const;
    void MatchFullWeighted(const MultiIndex& index, const char *dict, size_t max_phrases, int flags, const std::vector<std::string>& words, const std::vector<unsigned>& counts, TStringBuilder& buffer) const;
    void MatchFull(const MultiIndex& index, const char *dict, size_t max_phrases, int flags, const std::vector<std::string>& words, TStringBuilder& buffer) const;

private:

    std::vector<std::vector<unsigned> > masks;
};
