#pragma once

#include "BroadMatcher.h"

#include <rt-research/broadmatching/scripts/cpp-source/common/Server.h>

#include <util/generic/string.h>
#include <util/string/builder.h>

#include <map>
#include <string>

class MultiIndex;
class NormDict;

class CdictServer : public Server {
public:

    CdictServer(const MultiIndex& index, const NormDict& norm, int port);
    virtual void ExecCommand(const TStringBuf& cmd, Session* session);

private:

    void    PreprocessText(TString& text);
    void    GetDictValue(const char *dict, const char *key, TStringBuilder& buffer);

private:

    BroadMatcher    matcher;
    const MultiIndex& index;
    const NormDict& norm;
};
