#pragma once

#include "Index.h"

#include <vector>

class MultiIndex {
public:
    template <typename TIndexIterator>
    MultiIndex(TIndexIterator first, TIndexIterator last)
        : indeces_(first, last) {}

    void FindValue(
            const char* dict_name,
            const char* key,
            IndexValueType& value_type,
            const unsigned char*& value,
            const Index*& matched_index) const {
         value = NULL;
         matched_index = NULL;
         for (const Index* index_ptr : indeces_) {
             value = index_ptr->FindValue(dict_name, key, value_type);
             matched_index = index_ptr;
             if (value) {
                 break;
             }
         }
     }

private:
    std::vector<Index*> indeces_;
};
