#include "FileProcessor.h"

// описания методов в .h

size_t FileProcessor::get_file_size(const char *file_path) {
    size_t size = 0;
    std::ifstream stream(file_path, std::ifstream::in | std::ifstream::binary);
    if (stream) {
        stream.seekg(0, stream.end);
        size = stream.tellg();
        stream.close();
    }
    return size;
}

bool FileProcessor::process_file(const char* file_path) {
    size_t size = FileProcessor::get_file_size(file_path);
    if (size == 0) return false;

    // создаем структуры для тредов и промежуточных результатов
    std::vector<std::thread> threads;

    // раздаем чанки тредам
    size_t chunk_size = (size + _num_threads - 1) / _num_threads;
    for(size_t thr_i=0; thr_i<_num_threads; ++thr_i) {
        threads.push_back(
            std::thread(&FileProcessor::worker, this, file_path, thr_i, chunk_size)
        );
    }

    // ждем, пока все треды закончат обработку
    for(size_t thr_i=0; thr_i<threads.size(); ++thr_i)
        threads[thr_i].join();

    return true;
}

void FileProcessor::worker(
        const char *file_path,
        const size_t worker_i,
        const size_t chunk_size
    ) {
    _clear_data(worker_i);

    // заказываем буфер
    char buf_str[_buffer_size];
    char *buf_ptr = const_cast<char*>(buf_str);

    // определяем позиции начала и конца чанки
    size_t pos_cur = worker_i * chunk_size;
    size_t pos_end = (worker_i + 1) * chunk_size;

    // открываем ifstream
    std::ifstream stream(file_path, std::ifstream::in | std::ifstream::binary);
    // перемещемся на начало чанки
    stream.seekg(pos_cur, stream.beg);

    // идем до начала следующей строки
    // для корректной обработки, с середины строки обрабатывать сложно
    if (worker_i != 0) {
        char buf_char;
        while (stream.get(buf_char) && buf_char != '\n') ++pos_cur;
    }

    // идем построчно до конца чанки
    while (stream.good() && pos_cur < pos_end) {
        stream.getline(buf_str, _buffer_size);

        // обрабатываем строку
        if (buf_str[0]) {
            // сдвигаем ДО обработки,
            // т.к. во время обработки buf_ptr может измениться
            pos_cur += strlen(buf_str) + 1;
            process_line(buf_ptr, worker_i);
        }
    }
    stream.close();
}
