#pragma once

#include <util/generic/string.h>

// NOTE(danila-eremin) temporary added for compilation bender
#include <sstream>

#include <pthread.h>
#include <string>
#include <chrono>

#include <sys/socket.h>

#ifndef MSG_NOSIGNAL
#    define MSG_NOSIGNAL 0
#    ifdef SO_NOSIGPIPE
#        define USE_SO_NOSIGPIPE
#    endif /* !MSG_NOSIGNAL, !SO_NOSIGPIPE */
#endif /* !MSG_NOSIGNAL */

enum ServerLoggingLevel { None, Standard, Full };

class Session;

class Server {
public:

    Server(int port);
    virtual ~Server();

    // запустить цикл обработки входящих запросов
    void Run();

    // выполнить команду
    virtual void ExecCommand(const TStringBuf& /* cmd */, Session* /* session */);

    // остановить сервер
    void Stop();
    bool IsStopped() const  { return is_stopped; };

    // лок на ответ
    void LockResponse();
    void UnlockResponse();

    void setLoggingLevel( ServerLoggingLevel new_level ) { logging_level = new_level; }
    ServerLoggingLevel getLoggingLevel() { return logging_level; }

private:

    // ответить на запрос
    void SendResponse(int client_id, const char* data);

private:
    // закончил ли сервер работу
    bool is_stopped;

    // дескриптор сокета
    int socket_fd;

    // лок на ответ сервера
    pthread_mutex_t mutex_response;

protected:
    // уровень логгирования
    ServerLoggingLevel logging_level;

};
