#pragma once

#include <util/string/builder.h>

#include <string>

class Server;

class Session {
public:

    Session(int client_id, Server* server);
    Session(int client_id, Server* server, const std::string& client_addr);

    ~Session();

    // запустить цикл взаимодействия с клиентом
    void Run();

    // отправить ответ клиенту
    void SendResponse(const char* resp);
    void SendPartResponse(const TStringBuf& data);

    // прекращение сессии
    void Stop();

    int getClientId() { return client_id; }
    std::string getClientAddr() { return client_addr; }
private:

    int client_id;
    std::string client_addr;

    Server* server;
    bool is_stopped;
};
