#include "Tokens.h"

#include <clocale>
#include <cstdlib>
#include <cstring>
#include <cwctype>
#include <iostream>

#include <util/charset/unidata.h>

Tokens::Tokens() {
    std::setlocale(LC_CTYPE, "ru_RU.UTF-8");

    buffer_size_ = 10000;
    buffer_ = new char[buffer_size_];

    last_minus = 0;
    word_begin = 0;
    last_exclamation = 0;
    last_plus = 0;
    prev_space = 1;
    textlnth = 0;
    dont_change_cases = 0;

    init_uc2lc();
}

void Tokens::init_uc2lc() {
    char ttt[100];
    for (int i = 1; i < 65536; i++) {
        uc2lc[i] = (wchar_t)towlower(i);
        //Два символа, увеличивающие количество байтов при приведении к нижнему регистру
        if (i == 570) {
            uc2lc[i] = i;
        }
        if (i == 574) {
            uc2lc[i] = i;
        }

        if (i == uc2lc[i]) {
            uc2lc[i] = 0;
        }
        if (!iswalnum((wchar_t)i)) {
            uc2lc[i] = 32;
        } //Небуквенные символы заменяем на пробел
        if (i == 775) {
            uc2lc[i] = 0;
        } // Диакритический "штрих" над символом (например, в "i̇")

        if (i == 8381) {
            uc2lc[i] = i;
        } //Добавляем символ рубля
        if (i == 8364) {
            uc2lc[i] = i;
        }                                  //Добавляем символ евро
        int cc0 = wctomb(ttt, (wchar_t)i); //Длина исходного символа
        if (uc2lc[i] == 32) {
            uc2lc_cc[i] = cc0;
            uc2lc_wc[i] = new char[cc0];
            for (int j = 0; j < cc0; j++) {
                uc2lc_wc[i][j] = 32;
            }
            uc2lc_df[i] = 0;
        } else {
            int cc = wctomb(ttt, (wchar_t)uc2lc[i]);
            uc2lc_cc[i] = cc;
            uc2lc_wc[i] = new char[cc + 1];
            memcpy(uc2lc_wc[i], ttt, cc);
            uc2lc_wc[i][cc] = 0;
            uc2lc_df[i] = cc0 - cc;
        }
    }
}

void Tokens::utf8_lc(char* from) {
    static __thread wchar_t wc;
    static unsigned char i;
    static int delta;

    int badsmbl = 0;

    for (; *from;) {
        i = (unsigned char)(*from);
        if (i < 127) {
            if (i > 64 && i < 91) {
                *(from - badsmbl) = i + 32;
            } else if (badsmbl) {
                *(from - badsmbl) = i;
            }
            from++;
            continue;
        }

        delta = mbtowc(&wc, from, 4);
        if (wc >= (1 << 16)) {
            *from = ' ';
            delta = mbtowc(&wc, from, 4);
        }

        if (delta > 0) {
            if (uc2lc[wc]) {
                memcpy(from - badsmbl, uc2lc_wc[wc], uc2lc_cc[wc]);
                badsmbl += uc2lc_df[wc];
            } else {
                if (badsmbl) {
                    memcpy(from - badsmbl, from, delta);
                }
            }
            from += delta;
        } else if (!delta) {
            break;
        } else if (delta < 0) {
            badsmbl++;
            from++;
        }
    }
    if (badsmbl) {
        from -= badsmbl;
        from[0] = 0;
    }
}

void CharsToUtf8(const char* from, wchar_t* to, size_t max_size) {
    size_t i, j = 0;
    size_t len = strlen(from);
    wchar_t wc;

    for (i = 0; i < len && j < max_size;) {
        int delta = mbtowc(&wc, from + i, len - i);

        if (delta > 0) {
            i += (size_t)delta;
            to[j++] = towlower(wc);
        } else if (!delta) {
            break;
        } else if (delta < 0) {
            std::cout << "bad unicode: " << from << std::endl;
            i++;
        }
    }

    to[j] = 0;
}

void Utf8ToChars(const wchar_t* begin, const wchar_t* end, char* to) {
    while (begin != end) {
        to += wctomb(to, *begin);
        begin++;
    }

    *to = 0;
}

void Tokens::GetTokens(const char* text, std::vector<std::string>& tokens) {
    const size_t BUFFER_SIZE = 1024 * 1024;
    static __thread wchar_t wbuffer[BUFFER_SIZE];
    static __thread char buffer[BUFFER_SIZE];

    CharsToUtf8(text, wbuffer, BUFFER_SIZE - 1);
    tokens.clear();

    const wchar_t* p;
    const wchar_t* last_minus = 0;
    const wchar_t* word_begin = 0;
    const wchar_t* word_last = 0;
    const wchar_t* last_exclamation = 0;
    const wchar_t* last_plus = 0;
    int prev_space = 1;

    for (p = wbuffer; *p; p++) {
        wchar_t wc = *p;

        if (iswalnum(wc) || wc == '_') {
            if (!word_begin) {
                // начало нового слова
                if (last_minus && ((last_minus + 2 == p && last_exclamation && last_exclamation + 1 == p) || last_minus + 1 == p)) {
                    word_begin = last_minus;
                } else if (last_exclamation && last_exclamation + 1 == p) {
                    word_begin = last_exclamation;
                } else if (last_plus && last_plus + 1 == p) {
                    word_begin = last_plus;
                } else {
                    word_begin = p;
                }
            }

            word_last = p;
        } else if (wc == '-') {
            last_minus = p;
        } else if (wc == '.' && word_begin && iswdigit(*(p - 1)) && iswdigit(*(p + 1))) {
            // точки могут быть только между цифрами
        } else {
            if (!word_begin) {
                if ((wc == '!') && prev_space) {
                    last_exclamation = p;
                } else if ((wc == '+') && prev_space) {
                    last_plus = p;
                }
            }

            if (word_begin) {
                // конец слова
                Utf8ToChars(word_begin, word_last + 1, buffer);
                tokens.push_back(buffer);
                word_begin = 0;
            }

            prev_space = wc == ' ' || wc == '"';
        }
    }

    if (word_begin) {
        // конец слова
        Utf8ToChars(word_begin, word_last + 1, buffer);
        tokens.push_back(buffer);
    }
}

inline bool utf8_iswalnum(unsigned char ch) {
    if (ch > 127) {
        return true;
    }
    if (ch > 96 && ch < 123) {
        return true;
    }
    if (ch > 47 && ch < 58) {
        return true;
    }
    if (ch == 95) {
        return true;
    }
    return false;
}

void Tokens::GetTokensLite(const char* text, std::vector<char*>& tokens) {
    tokens.clear();

    //Копируем текст в буфер, чтобы не повредить его при обработке
    textlnth = strlen(text) + 1;

    if (buffer_size_ < textlnth + 1) {
        while (buffer_size_ < textlnth + 1) {
            buffer_size_ <<= 1;
        }
        delete[] buffer_;
        buffer_ = new char[buffer_size_];
    }
    memcpy(buffer_, text, textlnth);
    // # Копируем текст в буфер, чтобы не повредить его при обработке

    if (dont_change_cases == 0) {
        utf8_lc(buffer_);
    }

    last_minus = 0;
    word_begin = 0;
    last_exclamation = 0;
    last_plus = 0;
    prev_space = 1;
    prev_alnum = 1;

    for (p = buffer_; *p; p++) {
        unsigned char wc = *p;

        if (utf8_iswalnum(wc) || (wc == '$')) {
            if (!word_begin) {
                // начало нового слова
                if (last_minus && ((last_minus + 2 == p && (last_exclamation && last_exclamation + 1 == p || last_plus && last_plus + 1 == p)) || last_minus + 1 == p)) {
                    word_begin = last_minus;
                } else if (last_exclamation && last_exclamation + 1 == p) {
                    word_begin = last_exclamation;
                } else if (last_plus && last_plus + 1 == p) {
                    word_begin = last_plus;
                } else {
                    word_begin = p;
                }
            }

            prev_alnum = 1;
            prev_space = 0;
        } else if (wc == '-' && (utf8_iswalnum(*(p + 1)) || *(p + 1) == '!' || *(p + 1) == '+') && (prev_space || prev_alnum)) {
            if (prev_space) {
                last_minus = p;
            } else if (*(p + 1) == '+' || *(p + 1) == '!') {
                *p = 0;
                *(p + 1) = ' ';
            }
        } else if (wc == '.' && word_begin && IsCommonDigit(*(p - 1)) && IsCommonDigit(*(p + 1))) {
            // точки могут быть только между цифрами
            prev_alnum = 0;
        } else {
            if (!word_begin) {
                if ((wc == '!') && prev_space) {
                    last_exclamation = p;
                } else if ((wc == '+') && prev_space) {
                    last_plus = p;
                }
            } else {
                p[0] = 0;
            }

            if (word_begin) {
                // конец слова
                tokens.push_back(word_begin);
                word_begin = 0;
            }

            prev_space = wc == ' ' || wc == '"';
            prev_alnum = 0;
        }
    }
    if (word_begin) {
        // конец слова
        tokens.push_back(word_begin);
    }
}
