#pragma once

#include <string>
#include <vector>

class Tokens {
public:
    Tokens();

    void init_uc2lc();
    void utf8_lc(char *text);
    void GetTokensLite(const char *text, std::vector<char *>& tokens);
    static void GetTokens(const char *text, std::vector<std::string>& tokens);

    int dont_change_cases;

private:
    wchar_t uc2lc[65536];  //Соответствие символов разного регистра, небуквенные после 127 заменяются на пробел
    int   uc2lc_cc[65536]; //Длина символов в нижнем регистре
    char* uc2lc_wc[65536]; //Строка байтов для символа в нижнем регистре
    int   uc2lc_df[65536]; //Изменение длины в байтов после преобразования

    //Переменные для Tokens::GetTokensLite, чтобы не создавались каждый раз
    size_t buffer_size_;
    char* buffer_;
    char *p;
    char *last_minus;
    char *word_begin;
    char *last_exclamation;
    char *last_plus;
    int prev_space;
    int prev_alnum;
    size_t textlnth;
};
