#include "DatacampTskvDownloader.h"

#include <irt/common/lib/ProtoToTskv/ProtoToTskv.h>

#include <market/idx/datacamp/routines/tasks/ecom_export_offers_merged/proto/schemas.pb.h>

#include <util/system/env.h>

namespace NIRT {
    DatacampTskvDownloader::DatacampTskvDownloader(const TStringBuf& ytCluster,
                                                   const TStringBuf& sortedByBusinessTable)
            : sortedByBusinessTable(sortedByBusinessTable),
            ytCluster(ytCluster)
    {}

    bool DatacampTskvDownloader::Download(IOutputStream &stream, ui32 businessId, ui32 shopId, const TStringBuf &offerId) {
        const auto key = NYT::TReadLimit().Key({businessId, shopId, offerId});
        return DownloadFromYT(stream, sortedByBusinessTable, key);
    }

    bool DatacampTskvDownloader::Download(IOutputStream &stream, ui32 businessId, ui32 shopId) {
        const auto key = NYT::TReadLimit().Key({businessId, shopId});
        return DownloadFromYT(stream, sortedByBusinessTable, key);
    }

    bool DatacampTskvDownloader::Download(const TString &outFilename, ui32 businessId, ui32 shopId, const TStringBuf &offerId) {
        TOFStream outStream(outFilename);
        return Download(outStream, businessId, shopId, offerId);
    }
    bool DatacampTskvDownloader::Download(const TString &outFilename, ui32 businessId, ui32 shopId) {
        TOFStream outStream(outFilename);
        return Download(outStream, businessId, shopId);
    }

    bool DatacampTskvDownloader::DownloadFromYT(IOutputStream &stream, const TStringBuf &ytTable, const NYT::TReadLimit key) {
        auto ytPath = NYT::TRichYPath(TString(ytTable)).AddRange(
                NYT::TReadRange().Exact(key));

        auto client = NYT::CreateClient(TString(ytCluster));
        auto reader = client->CreateTableReader<Market::DataCamp::EcomExport::ExtendedExportMessageRowSchema>(ytPath);
        ProtoToTskv converter;

        if (!reader->IsValid() || reader->IsEndOfStream()) {
            return false;
        }
        for (; reader->IsValid(); reader->Next()) {
            const auto &row = reader->GetRow();
            const auto &data = row.GetData();
            converter.ProcessMessage(&data, stream);
            stream << Endl;
        };

        return true;
    }
}
