#pragma once

#include <google/protobuf/text_format.h>

#include <mapreduce/yt/interface/client.h>

namespace NIRT {
    const TString DEFAULT_OFFERS_TABLE_SORTED_BY_BUSINESS = "//home/market/production/ecom/export/offers/merged/recent";
    const TString DEFAULT_YT_CLUSTER = "arnold";

    class DatacampTskvDownloader {
    public:
        DatacampTskvDownloader(const TStringBuf& ytCluster=DEFAULT_YT_CLUSTER,
                               const TStringBuf& sortedByBusinessTable=DEFAULT_OFFERS_TABLE_SORTED_BY_BUSINESS);

        bool Download(IOutputStream &stream, ui32 businessId, ui32 shopId, const TStringBuf& offerId);
        bool Download(IOutputStream &stream, ui32 businessId, ui32 shopId);

        bool Download(const TString& outFilename, ui32 businessId, ui32 shopId, const TStringBuf& offerId);
        bool Download(const TString& outFilename, ui32 businessId, ui32 shopId);
    private:
        bool DownloadFromYT(IOutputStream &stream, const TStringBuf& ytTable, const NYT::TReadLimit key);
        const TString sortedByBusinessTable;
        const TString ytCluster;
    };
}
