#pragma once

#include "rpc_requester.h"

#include <library/cpp/json/json_value.h>
#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/response.h>
#include <library/cpp/http/misc/httpcodes.h>


namespace NIrt {


using TRpcProxyRequesterPtr = TAtomicSharedPtr<TRpcProxyRequester>;
using TRpcProxyAclPtr = TAtomicSharedPtr<TRpcProxyAcl>;


class TRpcProxyHttpReplier : public TRequestReplier {
    using THttpResponseValue = std::pair<HttpCodes, NJson::TJsonValue>;

public:
    TRpcProxyHttpReplier(
        TRpcProxyRequesterPtr requester,
        TRpcProxyAclPtr acl
    )
        : Requester(requester)
        , Acl(acl)
    { }

    bool DoReply(const TReplyParams& params);

private:
    THttpResponseValue DoReplyImpl(const TReplyParams& params);
    THttpResponseValue ActionSelect(NJson::TJsonValue input);
    THttpResponseValue ActionShutdown(NJson::TJsonValue input);

private:
    TRpcProxyRequesterPtr Requester;
    TRpcProxyAclPtr Acl;
};

class TRpcProxyHttpCallBack : public THttpServer::ICallBack {
public:
    TRpcProxyHttpCallBack(
        TRpcProxyRequesterPtr requester,
        TRpcProxyAclPtr acl
    )
        : Requester(requester)
        , Acl(acl)
    { }

    TClientRequest* CreateClient() override {
        return new TRpcProxyHttpReplier(Requester, Acl);
    }

private:
    TRpcProxyRequesterPtr Requester;
    TRpcProxyAclPtr Acl;
};


} // namespace NIrt
